/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.order;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.business.helper.SalOrderBillLogHelper;
import kd.scmc.sm.enums.ChangeStatusEnum;
import kd.scmc.sm.enums.StatusEnum;
import kd.scmc.sm.util.CommonUtils;
import kd.scmc.sm.validator.order.XSalSubmitValidator;

public class XSalOrderSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("entrychangetype");
        keys.add("srcid");
        keys.add("srcbillno");
        keys.add("org");
        keys.add("biztime");
        keys.add("r_recadvanceamount");
        keys.add("r_recamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new XSalSubmitValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        block25: {
            try (TraceSpan span = Tracer.create((String)"XSalOrderSaveOp", (String)("beforeExecuteOperationTransaction" + e.getOperationKey()));){
                if (!"save".equals(e.getOperationKey()) && !"submit".equals(e.getOperationKey()) || CommonUtils.isNull((Object)e.getDataEntities())) break block25;
                DynamicObject[] bills = e.getDataEntities();
                for (int i = 0; i < bills.length; ++i) {
                    DynamicObject bill = bills[i];
                    if (BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName(), (String)"id") != null) {
                        break;
                    }
                    String srcBillNo = bill.getString("srcbillno");
                    Long srcBillID = bill.getLong("srcid");
                    DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)srcBillID, (String)"sm_salorder");
                    if (ChangeStatusEnum.CHANGING.getValue().equals(srcBill.get("changestatus"))) {
                        e.cancel = true;
                        e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u201c%s\u201d\u6b63\u5728\u53d8\u66f4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"XSalOrderSaveOp_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), srcBillNo));
                        return;
                    }
                    if (!StatusEnum.AUDIT.getValue().equals(srcBill.get("billstatus"))) {
                        e.cancel = true;
                        e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u201c%1$s\u201d\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"XSalOrderSaveOp_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), srcBillNo));
                        return;
                    }
                    String xsal = bill.getDynamicObjectType().getName();
                    if (!xsal.equals("sm_xsalorder")) continue;
                    Date bizdate = bill.getDate("bizdate");
                    Date srcbiztime = bill.getDate("srcbiztime");
                    if (!srcbiztime.after(bizdate)) continue;
                    e.cancel = true;
                    e.setCancelMessage(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u8ba2\u5355\u65e5\u671f\u3002", (String)"XSalOrderSaveOp_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        try (TraceSpan span = Tracer.create((String)"XSalOrderSaveOp", (String)("endOperationTransaction" + e.getOperationKey()));){
            if (("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) && !CommonUtils.isNull((Object)e.getDataEntities())) {
                DynamicObject[] bills = e.getDataEntities();
                ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>();
                for (int i = 0; i < bills.length; ++i) {
                    DynamicObject bill = bills[i];
                    Long srcBillID = bill.getLong("srcid");
                    DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillID, (String)"sm_salorder");
                    if (srcBill == null) continue;
                    srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGING.getValue());
                    srcBills.add(srcBill);
                }
                if (srcBills.size() != 0) {
                    SaveServiceHelper.save((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        try (TraceSpan span = Tracer.create((String)"XSalOrderSaveOp", (String)("afterExecuteOperationTransaction" + e.getOperationKey()));){
            if (("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) && !CommonUtils.isNull((Object)e.getDataEntities())) {
                DynamicObject[] bills = e.getDataEntities();
                ArrayList<DynamicObject> xBillLogs = new ArrayList<DynamicObject>();
                for (int i = 0; i < bills.length; ++i) {
                    DynamicObject bill = bills[i];
                    MainEntityType xlogdt = MetadataServiceHelper.getDataEntityType((String)"sm_xsalorderlog");
                    DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.get("srcid"), (String)"sm_salorder");
                    DynamicObject xBill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getPkValue(), (String)"sm_xsalorder");
                    QFilter qFilter1 = new QFilter("srcbillid", "=", srcBill.getPkValue());
                    QFilter qFilter2 = new QFilter("xbillid", "=", bill.getPkValue());
                    QFilter qFilter3 = new QFilter("srcbillversion", "=", (Object)srcBill.getString("version"));
                    DeleteServiceHelper.delete((String)"sm_xsalorderlog", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                    DynamicObject xBillLog = new DynamicObject((DynamicObjectType)xlogdt);
                    xBillLog.set("srcbillid", srcBill.getPkValue());
                    xBillLog.set("srcbillno", (Object)srcBill.getString("billno"));
                    xBillLog.set("srcbillversion", (Object)srcBill.getString("version"));
                    xBillLog.set("xbillid", bill.getPkValue());
                    xBillLog.set("xbillno", (Object)bill.getString("billno"));
                    xBillLog.set("creator", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user"));
                    xBillLog.set("biztime", (Object)bill.getDate("bizdate"));
                    xBillLog.set("xreason", (Object)bill.getString("reason"));
                    Map map = SalOrderBillLogHelper.compareOrderBillNXOrderBill((DynamicObject)srcBill, (DynamicObject)xBill);
                    String xmdlog = (String)map.get("sm_salorder") + (String)map.get("billentry") + (String)map.get("recplanentry") + (String)map.get("orderdeliverentry");
                    xBillLog.set("xmdjson_tag", (Object)xmdlog);
                    xBillLogs.add(xBillLog);
                }
                if (xBillLogs.size() != 0) {
                    SaveServiceHelper.save((DynamicObject[])xBillLogs.toArray(new DynamicObject[0]));
                }
            }
        }
    }
}

