/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.quote;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.enums.ExChangeTypeEnum;
import kd.scmc.sm.validator.quote.PriceMustInputValidator;
import kd.scmc.sm.validator.quote.QuotationDateValidator;
import kd.scmc.sm.validator.tpl.KitSalesValidator;
import kd.scmc.sm.validator.tpl.OperatorGroupIsolateValidator;

public class QuotationBillOp
extends AbstractOperationServicePlugIn {
    public static final String BIZDATE = "bizdate";
    public static final String EFFECTDATE = "effectdate";
    public static final String EXPIRYDATE = "expirydate";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new QuotationDateValidator());
        e.addValidator((AbstractValidator)new OperatorGroupIsolateValidator());
        e.addValidator((AbstractValidator)new PriceMustInputValidator());
        e.addValidator((AbstractValidator)new KitSalesValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(BIZDATE);
        e.getFieldKeys().add(EFFECTDATE);
        e.getFieldKeys().add(EXPIRYDATE);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("operator");
        e.getFieldKeys().add("operatorgroup");
        e.getFieldKeys().add("exchangetype");
        e.getFieldKeys().add("istax");
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("price");
        e.getFieldKeys().add("priceandtax");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add("pricemodel");
        e.getFieldKeys().add("kitpid");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("baseunit");
        e.getFieldKeys().add("kitqty");
        e.getFieldKeys().add("parentqty");
        e.getFieldKeys().add("bom");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        if ("submit".equals(key)) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = e.getDataEntities()) {
                String exchangeType = bill.getString("exchangetype");
                if (exchangeType != null && !"".equals(exchangeType)) continue;
                bill.set("exchangetype", (Object)ExChangeTypeEnum.DIRECTRATE.getValue());
            }
            KitSalesHelper.setKitQtyDefValue((DynamicObject[])bills);
        }
    }
}

