/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.quote;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.scmc.operation.quote.events.AfterDoQuoteEventArgs;
import kd.bos.ext.scmc.operation.quote.events.BeforeDoQuoteEventArgs;
import kd.bos.ext.scmc.operation.quote.plugin.IQuoteDataHadler;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.sm.business.helper.BillTplHelper;

public class QuotationCalOp
implements IQuoteDataHadler {
    public void afterDoQuoteOperation(AfterDoQuoteEventArgs args) {
        if (!args.isIslistener()) {
            IDataModel model = args.getView().getModel();
            DynamicObject curObj = model.getDataEntity(true);
            DynamicObjectCollection billentry = curObj.getDynamicObjectCollection("billentry");
            Boolean istax = curObj.getBoolean("istax");
            for (int i = 0; i < billentry.size(); ++i) {
                BigDecimal price = ((DynamicObject)billentry.get(i)).getBigDecimal("price");
                BigDecimal priceAndTax = ((DynamicObject)billentry.get(i)).getBigDecimal("priceandtax");
                BigDecimal taxRate = ((DynamicObject)billentry.get(i)).getBigDecimal("taxrate");
                taxRate = taxRate.divide(new BigDecimal(100));
                if (istax.booleanValue()) {
                    price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), 10, 4);
                    ((DynamicObject)billentry.get(i)).set("price", (Object)price);
                    continue;
                }
                priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
                ((DynamicObject)billentry.get(i)).set("priceandtax", (Object)priceAndTax);
            }
            this.doRefresh(args.getSelectRows(), args.getView());
        }
    }

    public void beforeDoQuoteOperation(BeforeDoQuoteEventArgs args) {
        IDataModel model = args.getModel();
        int[] selectRows = args.getSelectRows();
        DynamicObject curObj = model.getDataEntity(true);
        Map priceMapObj = args.getQuoteDataEntity();
        if (priceMapObj.size() == 0) {
            args.setCancel(true);
            return;
        }
        Map<Object, DynamicObject> taxRates = this.queryActiveTaxRate(model);
        DynamicObjectCollection colls = model.getEntryEntity("billentry");
        for (Map priceMap : priceMapObj.values()) {
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject entryInfo = (DynamicObject)colls.get(selectRows[i]);
                int s = selectRows[i] + 1;
                String taxRateIDKey = curObj.getPkValue() + "$$" + entryInfo.getPkValue() + "$$" + s + "$$" + "taxrateid";
                String taxRateKey = curObj.getPkValue() + "$$" + entryInfo.getPkValue() + "$$" + s + "$$" + "taxrate";
                Long taxRateID = (Long)priceMap.get(taxRateIDKey);
                BigDecimal taxRate = (BigDecimal)priceMap.get(taxRateKey);
                if (taxRateID == null && taxRate != null) {
                    String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u4e2d\u53ea\u914d\u7f6e\u4e86\u201c\u7a0e\u7387%\u201d\uff0c\u6ca1\u6709\u914d\u7f6e\u201c\u7a0e\u7387\u201d\uff0c\u8bf7\u4fee\u6539\u53d6\u4ef7\u65b9\u6848\u3002", (String)"OrderQuoteOp_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                    args.setCancelMessage(message);
                    args.setCancel(true);
                    return;
                }
                if (taxRateID == null || taxRateID == null) continue;
                if (taxRates.get(taxRateID) == null) {
                    priceMap.put(taxRateIDKey, 0L);
                    priceMap.put(taxRateKey, BigDecimal.ZERO);
                    continue;
                }
                if (taxRate != null) continue;
                priceMap.put(taxRateKey, taxRates.get(taxRateID).getBigDecimal("taxrate"));
            }
        }
    }

    private Map<Object, DynamicObject> queryActiveTaxRate(IDataModel model) {
        Date bizTime = (Date)model.getValue("bizdate");
        QFilter q1 = new QFilter("activedate", "<=", (Object)bizTime);
        QFilter q2 = new QFilter("expdate", ">", (Object)bizTime);
        q1.and(q2).and(new QFilter("enable", "=", (Object)"1"));
        Map bdTaxrate = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id,name,number,taxrate", (QFilter[])new QFilter[]{q1});
        return bdTaxrate;
    }

    private void doRefresh(int[] selectRows, IFormView view) {
        boolean batchRefresh = false;
        if (selectRows == null) {
            view.updateView("billentry");
        } else {
            if (selectRows.length > BigDecimal.TEN.intValue()) {
                batchRefresh = true;
            }
            if (batchRefresh) {
                view.updateView("billentry");
            } else {
                String[] propNames = BillTplHelper.getEntryRefreshFields((String)"quote");
                if (propNames == null) {
                    return;
                }
                for (int i = 0; i < selectRows.length; ++i) {
                    for (String prop : propNames) {
                        view.updateView(prop, selectRows[i]);
                    }
                }
            }
        }
    }
}

