/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.quote;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.scmc.operation.quote.events.AfterDoQuoteEventArgs;
import kd.bos.ext.scmc.operation.quote.events.BeforeDoQuoteEventArgs;
import kd.bos.ext.scmc.operation.quote.plugin.IQuoteDataHadler;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.consts.Constants;
import kd.scmc.sm.enums.DiscountTypeEnum;

public class SalQuoteOp
implements IQuoteDataHadler {
    private static Log log = LogFactory.getLog(SalQuoteOp.class);
    private String[] ISPRESENT_FIELDS = new String[]{"discounttype", "discountrate", "amount", "amountandtax"};

    public void beforeDoQuoteOperation(BeforeDoQuoteEventArgs args) {
        IDataModel model = args.getModel();
        int[] selectRows = args.getSelectRows();
        DynamicObject curObj = model.getDataEntity(true);
        Map priceMapObj = args.getQuoteDataEntity();
        if (priceMapObj.size() == 0) {
            args.setCancel(true);
            return;
        }
        Map<Object, DynamicObject> taxRates = this.queryActiveTaxRate(model);
        DynamicObjectCollection colls = model.getEntryEntity("billentry");
        for (Map priceMap : priceMapObj.values()) {
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject entryInfo = (DynamicObject)colls.get(selectRows[i]);
                int s = selectRows[i] + 1;
                String taxRateIDKey = String.valueOf(curObj.getPkValue()) + "$$" + String.valueOf(entryInfo.getPkValue()) + "$$" + s + "$$" + "taxrateid";
                String taxRateKey = String.valueOf(curObj.getPkValue()) + "$$" + String.valueOf(entryInfo.getPkValue()) + "$$" + s + "$$" + "taxrate";
                Long taxRateID = (Long)priceMap.get(taxRateIDKey);
                BigDecimal taxRate = (BigDecimal)priceMap.get(taxRateKey);
                if (taxRateID == null && taxRate != null) {
                    String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u4e2d\u53ea\u914d\u7f6e\u4e86\u201c\u7a0e\u7387%\u201d\uff0c\u6ca1\u6709\u914d\u7f6e\u201c\u7a0e\u7387\u201d\uff0c\u8bf7\u4fee\u6539\u53d6\u4ef7\u65b9\u6848\u3002", (String)"OrderQuoteOp_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                    args.setCancelMessage(message);
                    args.setCancel(true);
                    return;
                }
                if (taxRateID == null || taxRateID == null) continue;
                if (taxRates.get(taxRateID) == null) {
                    priceMap.put(taxRateIDKey, 0L);
                    priceMap.put(taxRateKey, BigDecimal.ZERO);
                    continue;
                }
                if (taxRate != null) continue;
                priceMap.put(taxRateKey, taxRates.get(taxRateID).getBigDecimal("taxrate"));
            }
        }
    }

    public void afterDoQuoteOperation(AfterDoQuoteEventArgs args) {
        if (!args.isIslistener()) {
            IDataModel model = args.getView().getModel();
            DynamicObject curObj = model.getDataEntity(true);
            this.resetIsPresent(args.getSelectRows(), curObj, args.getView());
            long begin = System.currentTimeMillis();
            BillTplHelper.calculateAmount((DynamicObject)curObj, (int[])args.getSelectRows(), (IDataModel)model);
            this.doRefresh(null, args.getView());
            this.doRefreshHeadAmount(args.getView());
            long end = System.currentTimeMillis();
            log.info("\u624b\u52a8\u53d6\u4ef7\u8ba1\u7b97\u903b\u8f91\u8017\u65f6-" + (end - begin) + "\u6beb\u79d2");
        }
    }

    private Map<Object, DynamicObject> queryActiveTaxRate(IDataModel model) {
        Date bizTime = (Date)model.getValue("bizdate");
        QFilter q1 = new QFilter("activedate", "<=", (Object)bizTime);
        QFilter q2 = new QFilter("expdate", ">", (Object)bizTime);
        QFilter q3 = q2.or(QFilter.isNull((String)"expdate"));
        q1.and(q3).and(new QFilter("enable", "=", (Object)"1"));
        Map bdTaxrate = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id,name,number,taxrate", (QFilter[])new QFilter[]{q1});
        return bdTaxrate;
    }

    private void doRefresh(int[] selectRows, IFormView view) {
        boolean batchRefresh = false;
        if (selectRows == null) {
            view.updateView("billentry");
        } else {
            if (selectRows.length > BigDecimal.TEN.intValue()) {
                batchRefresh = true;
            }
            if (batchRefresh) {
                view.updateView("billentry");
            } else {
                String[] propNames = BillTplHelper.getEntryRefreshFields((String)"quote");
                if (propNames == null) {
                    return;
                }
                for (int i = 0; i < selectRows.length; ++i) {
                    for (String prop : propNames) {
                        view.updateView(prop, selectRows[i]);
                    }
                }
            }
        }
    }

    private void doRefreshHeadAmount(IFormView view) {
        view.updateView("totalallamount");
        view.updateView("totaltaxamount");
        view.updateView("totalamount");
        view.updateView("curtotalallamount");
        view.updateView("curtotaltaxamount");
        view.updateView("curtotalamount");
    }

    private void resetIsPresent(int[] rows, DynamicObject curObj, IFormView view) {
        boolean isTax = curObj.getBoolean("istax");
        DynamicObjectCollection billentrys = curObj.getDynamicObjectCollection("billentry");
        for (int i = 0; i < rows.length; ++i) {
            DynamicObject billentry = (DynamicObject)billentrys.get(rows[i]);
            boolean isPresent = billentry.getBoolean("ispresent");
            if (!isPresent) continue;
            if (isTax) {
                if (BigDecimalUtil.isZero((BigDecimal)billentry.getBigDecimal("priceandtax"))) {
                    billentry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                    billentry.set("discountrate", (Object)Constants.ZERO);
                    continue;
                }
                billentry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                billentry.set("discountrate", (Object)Constants.ONE_HUNDRED);
                continue;
            }
            if (BigDecimalUtil.isZero((BigDecimal)billentry.getBigDecimal("price"))) {
                billentry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                billentry.set("discountrate", (Object)Constants.ZERO);
                continue;
            }
            billentry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
            billentry.set("discountrate", (Object)Constants.ONE_HUNDRED);
        }
    }
}

