/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.tpl;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.opplugin.BillTypeCoreValidator;
import kd.mpscmm.msbd.opvalidate.validator.IsPresentValidator;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.enums.ExChangeTypeEnum;
import kd.scmc.sm.validator.order.BaseQtyValidator;
import kd.scmc.sm.validator.tpl.ConfiguredCodeValidator;
import kd.scmc.sm.validator.tpl.MaterialValidator;
import kd.scmc.sm.validator.tpl.OperatorGroupIsolateValidator;

public class BillTplSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("operator");
        e.getFieldKeys().add("operatorgroup");
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("reccustomer");
        e.getFieldKeys().add("reclinkman");
        e.getFieldKeys().add("receiveaddress");
        e.getFieldKeys().add("settlecustomer");
        e.getFieldKeys().add("payingcustomer");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("lastupdatetime");
        e.getFieldKeys().add("materialmasterid");
        e.getFieldKeys().add("materialname");
        e.getFieldKeys().add("configuredcode");
        e.getFieldKeys().add("exchangetype");
        e.getFieldKeys().add("entrychangetype");
        e.getFieldKeys().add("discountamount");
        e.getFieldKeys().add("amountandtax");
        e.getFieldKeys().add("ispresent");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new OperatorGroupIsolateValidator());
        e.addValidator((AbstractValidator)new BillTypeCoreValidator());
        e.addValidator((AbstractValidator)new MaterialValidator());
        e.addValidator((AbstractValidator)new ConfiguredCodeValidator());
        e.addValidator((AbstractValidator)new BaseQtyValidator());
        ArrayList<String> billName = new ArrayList<String>();
        billName.add("sm_salorder");
        billName.add("sm_xsalorder");
        billName.add("sm_xssalorder");
        billName.add("sm_delivernotice");
        billName.add("sm_returnapply");
        billName.add("sm_salesagency");
        String dateEnTityName = this.billEntityType.getName();
        if (!StringUtils.isEmpty((CharSequence)dateEnTityName) && billName != null && billName.contains(dateEnTityName)) {
            e.addValidator((AbstractValidator)new IsPresentValidator());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        DynamicObject user = UserServiceHelper.getCurrentUser((String)"id");
        Date now = TimeServiceHelper.now();
        for (DynamicObject bill : bills) {
            bill.set("lastupdateuser", (Object)user);
            bill.set("lastupdatetime", (Object)now);
            if (!"submit".equals(key)) continue;
            String exchangeType = bill.getString("exchangetype");
            if (exchangeType == null || "".equals(exchangeType)) {
                bill.set("exchangetype", (Object)ExChangeTypeEnum.DIRECTRATE.getValue());
            }
            DynamicObject customer = bill.getDynamicObject("customer");
            DynamicObject recCustomer = bill.getDynamicObject("reccustomer");
            DynamicObject settleCustomer = bill.getDynamicObject("settlecustomer");
            DynamicObject payingCustomer = bill.getDynamicObject("payingcustomer");
            if (recCustomer == null) {
                bill.set("reccustomer", (Object)customer);
                bill.set("reclinkman", (Object)CustomerHelper.getLinkmanObject((DynamicObject)customer));
                bill.set("receiveaddress", (Object)CustomerHelper.getAddress((DynamicObject)customer));
            }
            if (settleCustomer == null) {
                bill.set("settlecustomer", (Object)customer);
            }
            if (payingCustomer != null) continue;
            bill.set("payingcustomer", (Object)customer);
        }
    }
}

