/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.agency;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.scmc.sm.business.helper.MaterialHelper;

public class SalesAgencyOtherValidator
extends AbstractValidator {
    private static final String IS_CHECK_BOOK_DATE = "ischeckbookdate";
    private static final String IS_CHECK_CUSTOMER = "ischeckcustomer";
    private static final String IS_CHECK_MATERIAL_TYPE = "ischeckmaterialtype";
    private static final String IS_CHECK_STOCK_ORG = "ischeckstockorg";
    private static final String IS_CHECK_UN_VERIFY_QTY = "ischeckunverifyqty";
    private static final String IS_CHECK_TAX_ACTIVE_DATE = "ischecktaxactivedate";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final Map<Long, List<Long>> stockOrgCache = new HashMap<Long, List<Long>>(32);

    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>();
        }
        prepareProperties.add("org");
        prepareProperties.add("bizdate");
        prepareProperties.add("bookdate");
        prepareProperties.add("customer");
        prepareProperties.add("material");
        prepareProperties.add("e_stockorg");
        prepareProperties.add("qty");
        prepareProperties.add("entrustverifyqty");
        prepareProperties.add("entrustunverifyqty");
        prepareProperties.add("taxrateid");
        return prepareProperties;
    }

    public void validate() {
        Map<String, String> validParams = this.getValidParams();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!"false".equals(validParams.get(IS_CHECK_BOOK_DATE))) {
                this.validateBookDate(dataEntity);
            }
            if (!"false".equals(validParams.get(IS_CHECK_CUSTOMER))) {
                this.validateCustomer(dataEntity);
            }
            DynamicObject org = bill.getDynamicObject("org");
            Date bizDate = bill.getDate("bizdate");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            if (entry == null) continue;
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject row = (DynamicObject)entry.get(i);
                if (!"false".equals(validParams.get(IS_CHECK_MATERIAL_TYPE))) {
                    this.validateMaterial(dataEntity, row, i);
                }
                if (!"false".equals(validParams.get(IS_CHECK_STOCK_ORG))) {
                    this.validateStockOrg(dataEntity, org, row, i);
                }
                if ("false".equals(validParams.get(IS_CHECK_UN_VERIFY_QTY))) continue;
                this.validateQty(dataEntity, row, i);
            }
        }
    }

    private void validateCustomer(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObject customer = bill.getDynamicObject("customer");
        if (customer == null) {
            return;
        }
        if (!customer.getBoolean("consignment")) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u201c%1$s\u201d\u4e0d\u662f\u53ef\u5bc4\u552e\u5ba2\u6237\u3002", (String)"SalesAgencyOtherValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), customer.getString("number")));
        }
    }

    private Map<String, String> getValidParams() {
        HashMap<String, String> validParams = new HashMap<String, String>(16);
        String customParameter = (String)this.getValidation().get("customparameter");
        List params = MethodParameterUtil.fromJsonString((Object)customParameter);
        if (params != null) {
            for (Map map : params) {
                validParams.put((String)map.get("name"), (String)map.get("val"));
            }
        }
        return validParams;
    }

    private void validateQty(ExtendedDataEntity dataEntity, DynamicObject row, int rowIndex) {
        BigDecimal qty = BigDecimalUtil.getNotNull((Object)row.get("qty"));
        BigDecimal verifyQty = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("entrustverifyqty"));
        BigDecimal unVerifyQty = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("entrustunverifyqty"));
        if (!BigDecimalUtil.equals((BigDecimal)unVerifyQty, (BigDecimal)qty.subtract(verifyQty))) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u672a\u7ed3\u7b97\u6570\u91cf\u5e94\u7b49\u4e8e\u6570\u91cf\u4e0e\u5df2\u7ed3\u7b97\u6570\u91cf\u7684\u5dee\u503c\u3002", (String)"SalesAgencyOtherValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), rowIndex + 1));
        }
    }

    private void validateStockOrg(ExtendedDataEntity dataEntity, DynamicObject org, DynamicObject row, int rowIndex) {
        List<Long> stockOrgIds;
        if (org == null) {
            return;
        }
        DynamicObject deliverOrg = row.getDynamicObject("e_stockorg");
        if (deliverOrg != null && !(stockOrgIds = this.getStockOrgFromCache((Long)org.getPkValue())).isEmpty() && !stockOrgIds.contains((Long)deliverOrg.getPkValue())) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u53d1\u8d27\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"SalesAgencyOtherValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), rowIndex + 1, deliverOrg.getString("number")));
        }
    }

    private List<Long> getStockOrgFromCache(Long orgId) {
        List stockOrgIds = this.stockOrgCache.get(orgId);
        if (stockOrgIds == null) {
            stockOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)orgId, (String)"03", (String)"05", (String)"toorg");
            if (stockOrgIds == null) {
                stockOrgIds = Collections.emptyList();
            }
            this.stockOrgCache.put(orgId, stockOrgIds);
        }
        return stockOrgIds;
    }

    private void validateMaterial(ExtendedDataEntity dataEntity, DynamicObject row, int rowIndex) {
        DynamicObject material = row.getDynamicObject("material");
        if (!MaterialHelper.isEnableConsign((DynamicObject)material, (boolean)false) || !MaterialHelper.isMaterialType((DynamicObject)material, (boolean)false)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u7269\u6599\u201d\u9700\u4e3a\u53ef\u5bc4\u552e\u7269\u8d44\u7c7b\u7269\u6599\u3002", (String)"SalesAgencyOtherValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), rowIndex + 1));
        }
    }

    private void validateBookDate(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        Date bizDate = bill.getDate("bizdate");
        Date bookDate = bill.getDate("bookdate");
        if (bizDate != null && bookDate != null && bookDate.before(bizDate)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\u201c%1$s\u201d\u5c0f\u4e8e\u4e1a\u52a1\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"SalesAgencyOtherValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), this.dateFormat.format(bookDate), this.dateFormat.format(bizDate)));
        }
    }
}

