/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.agency;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.sm.business.helper.SystemCallParamHelper;

public class SalesAgencySubmitValidator
extends AbstractValidator {
    public void validate() {
        Boolean isBookDateEqBizDate = SystemCallParamHelper.isBookDateEqBizDate();
        if (isBookDateEqBizDate.booleanValue()) {
            return;
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            String bizDateFormat;
            DynamicObject bill = data.getDataEntity();
            if (bill == null) continue;
            Date bizDate = bill.getDate("bizdate");
            Date bookDate = bill.getDate("bookdate");
            String billNo = bill.getString("billno");
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (bizDate == null) continue;
            if (bookDate == null) {
                bizDateFormat = simpleFormat.format(bizDate);
                this.setAddBillNoForContent(false);
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5355\u636e\u201c%1$s\u201d\u7684\u8bb0\u8d26\u65e5\u671f\u201c%2$s\u201d\u5c0f\u4e8e\u4e1a\u52a1\u65e5\u671f\u201c%3$s\u201d\u3002", (String)"SalesAgencySubmitValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), billNo, "", bizDateFormat), ErrorLevel.Error);
                continue;
            }
            if (!bookDate.before(bizDate)) continue;
            bizDateFormat = simpleFormat.format(bizDate);
            String bookDateFormat = simpleFormat.format(bookDate);
            this.setAddBillNoForContent(false);
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5355\u636e\u201c%1$s\u201d\u7684\u8bb0\u8d26\u65e5\u671f\u201c%2$s\u201d\u5c0f\u4e8e\u4e1a\u52a1\u65e5\u671f\u201c%3$s\u201d\u3002", (String)"SalesAgencySubmitValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), billNo, bookDateFormat, bizDateFormat), ErrorLevel.Error);
        }
    }
}

