/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.core;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.enums.CustomerFunction;

public class CustomerValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("customer");
        preparePropertys.add("linkman");
        preparePropertys.add("payingcustomer");
        preparePropertys.add("settlecustomer");
        preparePropertys.add("reccustomer");
        preparePropertys.add("reclinkman");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject recLinkman;
            DynamicObject recCustomer;
            DynamicObject settleCustomer;
            DynamicObject payCustomer;
            DynamicObject linkman;
            DynamicObject bill = extend.getDataEntity();
            DynamicObject customer = bill.getDynamicObject("customer");
            if (customer != null) {
                if (!CustomerHelper.checkBizFunction((DynamicObject)customer, (CustomerFunction)CustomerFunction.SALE)) {
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%1$s\u201d\u4e0d\u5177\u6709\u9500\u552e\u804c\u80fd\u3002", (String)"CustomerValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), customer.getString("number")), ErrorLevel.Error);
                }
                if (CustomerHelper.isBlockedorder((DynamicObject)customer)) {
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%1$s\u201d\u5df2\u9500\u552e\u51bb\u7ed3\u3002", (String)"CustomerValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), customer.getString("number")), ErrorLevel.Error);
                }
            }
            if ((linkman = bill.getDynamicObject("linkman")) != null && !CustomerHelper.getAllLinkMans((DynamicObject)customer).contains(linkman.getPkValue())) {
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u201c%1$s\u201d\u4e0d\u662f\u5f53\u524d\u8ba2\u8d27\u5ba2\u6237\u7684\u6709\u6548\u8054\u7cfb\u4eba\u3002", (String)"CustomerValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), linkman.getString("contactperson")), ErrorLevel.Error);
            }
            if ((payCustomer = bill.getDynamicObject("payingcustomer")) != null && !CustomerHelper.checkBizFunction((DynamicObject)payCustomer, (CustomerFunction)CustomerFunction.PAY)) {
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5ba2\u6237\u201c%1$s\u201d\u4e0d\u5177\u6709\u4ed8\u6b3e\u804c\u80fd\u3002", (String)"CustomerValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), payCustomer.getString("number")), ErrorLevel.Error);
            }
            if ((settleCustomer = bill.getDynamicObject("settlecustomer")) != null && !CustomerHelper.checkBizFunction((DynamicObject)settleCustomer, (CustomerFunction)CustomerFunction.SETTLE)) {
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237\u201c%1$s\u201d\u4e0d\u5177\u6709\u7ed3\u7b97\u804c\u80fd\u3002", (String)"CustomerValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), settleCustomer.getString("number")), ErrorLevel.Error);
            }
            if ((recCustomer = bill.getDynamicObject("reccustomer")) == null) continue;
            if (!CustomerHelper.checkBizFunction((DynamicObject)recCustomer, (CustomerFunction)CustomerFunction.RECEIVE)) {
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u6536\u8d27\u5ba2\u6237\u201c%1$s\u201d\u4e0d\u5177\u6709\u6536\u8d27\u804c\u80fd\u3002", (String)"CustomerValidator_5", (String)"scmc-sm-opplugin", (Object[])new Object[0]), recCustomer.getString("number")), ErrorLevel.Error);
            }
            if ((recLinkman = bill.getDynamicObject("reclinkman")) == null || CustomerHelper.getAllLinkMans((DynamicObject)recCustomer).contains(recLinkman.getPkValue())) continue;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u6536\u8d27\u8054\u7cfb\u4eba\u201c%1$s\u201d\u4e0d\u662f\u5f53\u524d\u6536\u8d27\u5ba2\u6237\u7684\u6709\u6548\u8054\u7cfb\u4eba\u3002", (String)"CustomerValidator_6", (String)"scmc-sm-opplugin", (Object[])new Object[0]), recLinkman.getString("contactperson")), ErrorLevel.Error);
        }
    }
}

