/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.helper.LotCacheHelper;

public class LotValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("material");
        preparePropertys.add("lotnumber");
        preparePropertys.add("lot");
        preparePropertys.add("e_stockorg");
        preparePropertys.add("deliverorg");
        preparePropertys.add("entryinvorg");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            String tipMsg;
            DynamicObject bill = data.getDataEntity();
            String entityId = bill.getDataEntityType().getName();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            Map resultMap = LotCacheHelper.checkLot((DynamicObject)bill);
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject billEntry = (DynamicObject)entrys.get(i);
                DynamicObject invOrg = LotCacheHelper.getInvOrg((DynamicObject)bill, (DynamicObject)billEntry);
                String lotNumber = billEntry.getString("lotnumber");
                if (invOrg != null || lotNumber == null || lotNumber.isEmpty()) continue;
                tipMsg = "sm_returnapply".equals(entityId) ? String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5e93\u5b58\u7ec4\u7ec7\u662f\u7a7a\u65f6\uff0c\u6279\u53f7\u4e0d\u5141\u8bb8\u5f55\u5165\u3002", (String)"LotValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1) : String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u53d1\u8d27\u7ec4\u7ec7\u662f\u7a7a\u65f6\uff0c\u6279\u53f7\u4e0d\u5141\u8bb8\u5f55\u5165\u3002", (String)"LotValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                this.addMessage(data, tipMsg, ErrorLevel.Error);
            }
            if (resultMap == null || resultMap.size() <= 0) continue;
            for (Map.Entry entry : resultMap.entrySet()) {
                DynamicObject billEntry = (DynamicObject)entrys.get(((Integer)entry.getKey()).intValue());
                DynamicObject invOrg = LotCacheHelper.getInvOrg((DynamicObject)bill, (DynamicObject)billEntry);
                DynamicObject material = billEntry.getDynamicObject("material").getDynamicObject("masterid");
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                tipMsg = "sm_returnapply".equals(entityId) ? String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u5728\u5e93\u5b58\u7ec4\u7ec7\u201c%3$s\u201d\u672a\u5f00\u542f\u6279\u53f7\u7ba1\u7406\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u6279\u53f7\u3002", (String)"LotValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), (Integer)entry.getKey() + 1, material.getString("number"), invOrg.getString("number")) : String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u5728\u53d1\u8d27\u7ec4\u7ec7\u201c%3$s\u201d\u672a\u5f00\u542f\u6279\u53f7\u7ba1\u7406\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u6279\u53f7\u3002", (String)"LotValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), (Integer)entry.getKey() + 1, material.getString("number"), invOrg.getString("number"));
                this.addMessage(data, tipMsg, ErrorLevel.Error);
            }
        }
    }
}

