/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class OwnerValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("billno");
        preparePropertys.add("supplier");
        preparePropertys.add("ownertype");
        preparePropertys.add("owner");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            String entityName = bill.getDataEntityType().getName();
            String stockOrgName = null;
            stockOrgName = "sm_returnapply".equals(entityName) ? "entryinvorg" : "e_stockorg";
            HashMap<String, Set<Long>> cacheMap = new HashMap<String, Set<Long>>(8);
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String ownertype = entry.getString("ownertype");
                DynamicObject owner = entry.getDynamicObject("owner");
                if (owner == null) continue;
                if ("bd_supplier".equals(ownertype)) {
                    String tipMsg;
                    DynamicObject masterMaterial;
                    DynamicObject material = entry.getDynamicObject("material");
                    if (material == null || (masterMaterial = material.getDynamicObject("masterid")) == null) continue;
                    if (!masterMaterial.getBoolean("enablevmi")) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u4e0d\u662f\u53efVMI\u7684\u7269\u6599\u3002", (String)"OwnerValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, material.getDynamicObject("masterid").getString("number"));
                        this.addMessage(data, tipMsg, ErrorLevel.Error);
                    }
                    if (!owner.containsProperty("enablevmi") || !owner.getBoolean("enablevmi")) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u8d27\u4e3b\u201c%2$s\u201d\u4e0d\u662f\u53efVMI\u7684\u4f9b\u5e94\u5546\u3002", (String)"OwnerValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, owner.getString("number"));
                        this.addMessage(data, tipMsg, ErrorLevel.Error);
                    }
                }
                if (!"bos_org".equals(ownertype)) continue;
                DynamicObject entryRecOrg = (DynamicObject)entry.get(stockOrgName);
                HashSet ownerIds = new HashSet(8);
                if (entryRecOrg == null) continue;
                Long entryRecOrgId = (Long)entryRecOrg.getPkValue();
                String ownerCacheKey = entryRecOrgId + "owner";
                if (OwnerValidator.isCache(cacheMap, ownerCacheKey)) {
                    ownerIds.addAll((Collection)cacheMap.get(ownerCacheKey));
                } else {
                    Map orgRelation = OrgHelper.getOrgRelation((Long)entryRecOrgId, (String)"10", (String)"05", (String)"fromorg");
                    if (orgRelation != null) {
                        ownerIds.addAll((List)orgRelation.get("orgId"));
                        cacheMap.put(ownerCacheKey, ownerIds);
                    }
                }
                if (ownerIds.size() <= 0 || ownerIds.contains(owner.getPkValue())) continue;
                String tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u8d27\u4e3b\u4e0d\u662f\u6ee1\u8db3\u6761\u4ef6\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OwnerValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                this.addMessage(data, tipMsg, ErrorLevel.Error);
            }
        }
    }

    private static boolean isCache(Map<String, Set<Long>> map, String key) {
        return map.containsKey(key);
    }
}

