/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.helper.IMServiceHelper;

public class WareHouseValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("e_stockorg");
        preparePropertys.add("warehouse");
        return preparePropertys;
    }

    public void validate() {
        HashMap<String, Set<Long>> cacheMap = new HashMap<String, Set<Long>>(8);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String entityName = bill.getDataEntityType().getName();
                String stockOrgName = null;
                stockOrgName = "sm_returnapply".equals(entityName) ? "entryinvorg" : "e_stockorg";
                DynamicObject entryinvOrg = entry.getDynamicObject(stockOrgName);
                DynamicObject warehouse = entry.getDynamicObject("warehouse");
                if (warehouse == null) continue;
                boolean checkResult = true;
                if (entryinvOrg != null) {
                    String cacheKey = "warehouse" + entryinvOrg.getPkValue();
                    if (WareHouseValidator.isCache(cacheMap, cacheKey)) {
                        Set whs = (Set)cacheMap.get(cacheKey);
                        if (whs == null || !whs.contains(warehouse.getPkValue())) {
                            checkResult = false;
                        }
                    } else {
                        Long[] allWhs = (Long[])IMServiceHelper.invokeBizService((String)"InvService", (String)"getAllWarehouseIDs", (Object[])new Object[]{entryinvOrg.getString("number")});
                        if (allWhs != null) {
                            HashSet<Long> whs = new HashSet<Long>(Arrays.asList(allWhs));
                            cacheMap.put(cacheKey, whs);
                            if (!whs.contains(warehouse.getPkValue())) {
                                checkResult = false;
                            }
                        } else {
                            checkResult = false;
                            cacheMap.put(cacheKey, null);
                        }
                    }
                    if (checkResult) continue;
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u4ed3\u5e93\u201c%2$s\u201d\u672a\u5206\u914d\u7ed9\u53d1\u8d27\u7ec4\u7ec7\u201c%3$s\u201d\u4f7f\u7528\u3002", (String)"WareHouseValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, warehouse.getString("number"), entryinvOrg.getString("number"));
                    this.addMessage(data, tipMsg, ErrorLevel.Error);
                    continue;
                }
                String tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5982\u9700\u5f55\u5165\u4ed3\u5e93\u65f6\uff0c\u8bf7\u5148\u5f55\u5165\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"WareHouseValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                this.addMessage(data, tipMsg, ErrorLevel.Error);
            }
        }
    }

    private static boolean isCache(Map<String, Set<Long>> map, String key) {
        return map.containsKey(key);
    }
}

