/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.notice;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class DeliverNoticeMateriaValidator
extends AbstractValidator {
    private static final Long AGENCY_BIZTYPE_ID = 688860294365375488L;
    private static final Long MATERIALS_ATTRIBUTE_ID = 1194029484878120960L;

    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            DynamicObject billtype = (DynamicObject)entity.get("billtype");
            DynamicObject biztype = entity.getDynamicObject("biztype");
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("billentry");
            if (entry.isEmpty() || billtype == null) continue;
            int i = 0;
            for (DynamicObject row : entry) {
                DynamicObject materialId;
                ++i;
                if (row.getDynamicObject("material") == null || (materialId = row.getDynamicObject("material").getDynamicObject("masterid")) == null) continue;
                DynamicObjectCollection materialServiceattribute = materialId.getDynamicObjectCollection("serviceattribute");
                List ids = materialServiceattribute.stream().map(dym -> dym.get("fbasedataid_id")).collect(Collectors.toList());
                boolean enableconsign = materialId.getBoolean("enableconsign");
                if (biztype == null || !Objects.equals(AGENCY_BIZTYPE_ID, biztype.getPkValue()) || enableconsign && ids.contains(MATERIALS_ATTRIBUTE_ID)) continue;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u7269\u6599\u201d\u9700\u4e3a\u53ef\u5bc4\u552e\u5e38\u89c4\u7c7b\u7269\u6599\u3002", (String)"DeliverNoticeMateriaValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i), ErrorLevel.Error);
            }
        }
    }
}

