/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.helper.AppParameterHelper;
import kd.scmc.sm.business.helper.SaleDataCtrlHelper;

public class CanSaleControlValidator
extends AbstractValidator {
    private static final String OPERMATERCTRL = "opermaterctrl";
    private static final String CUSMATERCTRL = "cusmaterctrl";

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billno");
        preparePropertys.add("org");
        preparePropertys.add("billstatus");
        preparePropertys.add("dept");
        preparePropertys.add("operatorgroup");
        preparePropertys.add("operator");
        preparePropertys.add("customer");
        preparePropertys.add("material");
        return preparePropertys;
    }

    public void validate() {
        HashMap<Long, List> billMap = new HashMap<Long, List>(8);
        for (ExtendedDataEntity extend : this.dataEntities) {
            String entityName;
            DynamicObject bill = extend.getDataEntity();
            if (bill == null || bill.get("org") == null || "sm_xsalorder".equals(entityName = bill.getDataEntityType().getName()) || "sm_xssalorder".equals(entityName)) continue;
            DynamicObject org = bill.getDynamicObject("org");
            List bills = billMap.computeIfAbsent((Long)org.getPkValue(), k -> new ArrayList());
            bills.add(bill);
        }
        if (CommonUtils.isNull(billMap)) {
            return;
        }
        Map cusResult = SaleDataCtrlHelper.checkCustomerData(billMap);
        Map materResult = SaleDataCtrlHelper.checkMaterialData(billMap);
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject bill = extend.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject customer = bill.getDynamicObject("customer");
            if (cusResult != null && cusResult.size() > 0 && cusResult.get((Long)bill.getPkValue()) != null) {
                Map cusMap = (Map)cusResult.get((Long)bill.getPkValue());
                if (customer != null && cusMap != null && !Boolean.TRUE.equals(cusMap.get((Long)customer.getPkValue()))) {
                    String tip = String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%1$s\u201d\uff0c\u9488\u5bf9\u8ba2\u5355\u5f53\u524d\u9500\u552e\u5458\uff08\u7ec4\u3001\u90e8\u95e8\uff09\u4e0d\u53ef\u9500\u3002", (String)"CanSaleControlValidator_7", (String)"scmc-sm-opplugin", (Object[])new Object[0]), customer.getString("name"));
                    this.addMessage(extend, tip, ErrorLevel.Error);
                }
            }
            if (materResult == null || materResult.size() <= 0 || materResult.get(bill.getPkValue()) == null) continue;
            Map materMap = (Map)materResult.get(bill.getPkValue());
            Boolean operControl = (Boolean)AppParameterHelper.getSmAppParameter((Long)((Long)org.getPkValue()), (String)OPERMATERCTRL);
            Boolean cusControl = (Boolean)AppParameterHelper.getSmAppParameter((Long)((Long)org.getPkValue()), (String)CUSMATERCTRL);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                String tip;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || Boolean.TRUE.equals(materMap.get((Long)material.getDynamicObject("masterid").getPkValue()))) continue;
                if (Boolean.FALSE.equals(operControl) && Boolean.TRUE.equals(cusControl)) {
                    tip = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c,\u9488\u5bf9\u8ba2\u5355\u5f53\u524d\u8ba2\u8d27\u5ba2\u6237\u4e0d\u53ef\u9500\u3002", (String)"CanSaleControlValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                    this.addMessage(extend, tip, ErrorLevel.Error);
                }
                if (Boolean.TRUE.equals(operControl) && Boolean.FALSE.equals(cusControl)) {
                    tip = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c,\u9488\u5bf9\u8ba2\u5355\u5f53\u524d\u9500\u552e\u5458\uff08\u7ec4\u3001\u90e8\u95e8\uff09\u4e0d\u53ef\u9500\u3002", (String)"CanSaleControlValidator_5", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                    this.addMessage(extend, tip, ErrorLevel.Error);
                }
                if (!Boolean.TRUE.equals(operControl) || !Boolean.TRUE.equals(cusControl)) continue;
                tip = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c,\u9488\u5bf9\u8ba2\u5355\u5f53\u524d\u9500\u552e\u5458\uff08\u7ec4\u3001\u90e8\u95e8\uff09\u6216\u8ba2\u8d27\u5ba2\u6237\u4e0d\u53ef\u9500\u3002", (String)"CanSaleControlValidator_6", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                this.addMessage(extend, tip, ErrorLevel.Error);
            }
        }
    }
}

