/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class DeliverInfoValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("bizdate");
        preparePropertys.add("iscontrolday");
        preparePropertys.add("deliverydate");
        preparePropertys.add("deliveradvdays");
        preparePropertys.add("deliverdelaydays");
        preparePropertys.add("iscontrolqty");
        preparePropertys.add("deliverrateup");
        preparePropertys.add("deliverratedown");
        preparePropertys.add("deliverqtyup");
        preparePropertys.add("deliverqtydown");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            Date bizDate = bill.getDate("bizdate");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                Boolean iscontrolqty;
                String tipMsg;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                Boolean iscontrolday = entry.getBoolean("iscontrolday");
                if (Boolean.FALSE.equals(iscontrolday)) {
                    int deliverdayup = entry.getInt("deliveradvdays");
                    int deliverdaydown = entry.getInt("deliverdelaydays");
                    if (deliverdayup != 0) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u63a7\u5236\u65f6\u95f4\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u5141\u8bb8\u63d0\u524d\u5929\u6570\u3002", (String)"DeliverInfoValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                        this.addMessage(data, tipMsg, ErrorLevel.Error);
                    }
                    if (deliverdaydown != 0) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u63a7\u5236\u65f6\u95f4\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u5141\u8bb8\u5ef6\u8fdf\u5929\u6570\u3002", (String)"DeliverInfoValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                        this.addMessage(data, tipMsg, ErrorLevel.Error);
                    }
                }
                if (Boolean.FALSE.equals(iscontrolqty = Boolean.valueOf(entry.getBoolean("iscontrolqty")))) {
                    String tipMsg2;
                    BigDecimal deliveratedown = entry.getBigDecimal("deliverratedown");
                    BigDecimal deliverateup = entry.getBigDecimal("deliverrateup");
                    if (BigDecimalUtil.isNotBlank((BigDecimal)deliveratedown)) {
                        tipMsg2 = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u63a7\u5236\u53d1\u8d27\u6570\u91cf\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u53d1\u8d27\u6b20\u53d1\u6bd4\u7387(%2$s)\u3002", (String)"DeliverInfoValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, "%");
                        this.addMessage(data, tipMsg2, ErrorLevel.Error);
                    }
                    if (BigDecimalUtil.isNotBlank((BigDecimal)deliverateup)) {
                        tipMsg2 = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u63a7\u5236\u53d1\u8d27\u6570\u91cf\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u53d1\u8d27\u8d85\u53d1\u6bd4\u7387(%2$s)\u3002", (String)"DeliverInfoValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, "%");
                        this.addMessage(data, tipMsg2, ErrorLevel.Error);
                    }
                }
                Date deliverDate = entry.getDate("deliverydate");
                if (bizDate == null || deliverDate == null || deliverDate.compareTo(bizDate) >= 0) continue;
                tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u53d1\u8d27\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8ba2\u5355\u65e5\u671f\u3002", (String)"DeliverInfoValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                this.addMessage(data, tipMsg, ErrorLevel.Error);
            }
        }
    }
}

