/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.sm.consts.Constants;
import kd.scmc.sm.enums.DiscountTypeEnum;

public class DiscountTypeValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            Boolean istax = (Boolean)entity.get("istax");
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("billentry");
            if (entry.size() <= 0) continue;
            int i = 0;
            for (DynamicObject row : entry) {
                String tip;
                ++i;
                BigDecimal disCountRate = row.getBigDecimal("discountrate");
                if (row.getString("discounttype").equals(DiscountTypeEnum.DISRATE.getValue())) {
                    String tip2;
                    if (disCountRate.compareTo(new BigDecimal(100)) > 0) {
                        tip2 = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5927\u4e8e100%2$s\u3002", (String)"DiscountTypeValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i, "%");
                        this.addMessage(extend, tip2, ErrorLevel.Error);
                    } else if (disCountRate.compareTo(Constants.ZERO) < 0) {
                        tip2 = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"DiscountTypeValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i);
                        this.addMessage(extend, tip2, ErrorLevel.Error);
                    }
                }
                if (istax.booleanValue()) {
                    if (!row.getString("discounttype").equals(DiscountTypeEnum.UNITDIS.getValue())) continue;
                    BigDecimal priceAndTax = row.getBigDecimal("priceandtax");
                    if (disCountRate.compareTo(priceAndTax) > 0) {
                        tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"DiscountTypeValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i);
                        this.addMessage(extend, tip, ErrorLevel.Error);
                        continue;
                    }
                    if (disCountRate.compareTo(Constants.ZERO) >= 0) continue;
                    tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"DiscountTypeValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i);
                    this.addMessage(extend, tip, ErrorLevel.Error);
                    continue;
                }
                if (!row.getString("discounttype").equals(DiscountTypeEnum.UNITDIS.getValue())) continue;
                BigDecimal price = row.getBigDecimal("price");
                if (disCountRate.compareTo(price) > 0) {
                    tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"DiscountTypeValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i);
                    this.addMessage(extend, tip, ErrorLevel.Error);
                    continue;
                }
                if (disCountRate.compareTo(Constants.ZERO) >= 0) continue;
                tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"DiscountTypeValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i);
                this.addMessage(extend, tip, ErrorLevel.Error);
            }
        }
    }
}

