/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class MinOrderQtyValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.isEmpty()) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject billEntry = (DynamicObject)entrys.get(i);
                BigDecimal minOrderBaseQty = billEntry.getBigDecimal("minorderbaseqty");
                if (minOrderBaseQty == null || BigDecimal.ZERO.compareTo(minOrderBaseQty) == 0) continue;
                BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
                if (BigDecimal.ZERO.compareTo(minOrderBaseQty) == 0 || minOrderBaseQty.compareTo(baseQty) <= 0) continue;
                String errMsg = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\u201c\u6570\u91cf\u201d\u5c0f\u4e8e\u7269\u6599\u9500\u552e\u4fe1\u606f\u4e2d\u7ea6\u5b9a\u7684\u201c\u8d77\u9500\u91cf\u201d, \u4e0d\u5141\u8bb8%2$s\u3002", (String)"MinOrderQtyValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, this.getOperationName());
                this.addMessage(entity, errMsg, ErrorLevel.Error);
            }
        }
    }
}

