/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class OrgValidator
extends AbstractValidator {
    public static String PARA_ISCHECKSETTLEDEPT = "ischecksettledept";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("e_stockorg");
        preparePropertys.add("entrysettleorg");
        preparePropertys.add("settledept");
        preparePropertys.add("supplytrans");
        preparePropertys.add("purorg");
        return preparePropertys;
    }

    public void validate() {
        String customparameter = (String)this.getValidation().get("customparameter");
        HashMap<String, List<Long>> cacheMap = new HashMap<String, List<Long>>(8);
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject bill = extend.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) {
                return;
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject settleDept;
                DynamicObject settleOrg;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject deliverOrg = entry.getDynamicObject("e_stockorg");
                if (deliverOrg != null) {
                    String cacheKey = String.valueOf(deliverOrg.getPkValue()) + "e_stockorg";
                    List deliverOrgIds = new ArrayList(8);
                    if (OrgValidator.isCache(cacheMap, cacheKey)) {
                        deliverOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                    } else {
                        deliverOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"03", (String)"05", (String)"toorg");
                        cacheMap.put(cacheKey, deliverOrgIds);
                    }
                    if (deliverOrgIds != null && deliverOrgIds.size() > 0 && !deliverOrgIds.contains(deliverOrg.getPkValue())) {
                        this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u53d1\u8d27\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"OrgValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, deliverOrg.getString("number")), ErrorLevel.Error);
                    }
                }
                if ((settleOrg = entry.getDynamicObject("entrysettleorg")) != null) {
                    String cacheKey = String.valueOf(settleOrg.getPkValue()) + "entrysettleorg";
                    List settleOrgIds = new ArrayList(8);
                    if (OrgValidator.isCache(cacheMap, cacheKey)) {
                        settleOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                    } else {
                        settleOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"03", (String)"10", (String)"toorg");
                        cacheMap.put(cacheKey, settleOrgIds);
                    }
                    if (settleOrgIds != null && settleOrgIds.size() > 0 && !settleOrgIds.contains(settleOrg.getPkValue())) {
                        this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u7ed3\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"OrgValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, settleOrg.getString("number")), ErrorLevel.Error);
                    }
                }
                if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKSETTLEDEPT)) || (settleDept = entry.getDynamicObject("settledept")) == null || settleOrg == null) continue;
                String cacheKey = String.valueOf(settleDept.getPkValue()) + "settledept";
                List settleDeptIds = new ArrayList(8);
                if (OrgValidator.isCache(cacheMap, cacheKey)) {
                    settleDeptIds.addAll((Collection)cacheMap.get(cacheKey));
                } else {
                    settleDeptIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)settleOrg.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                    cacheMap.put(cacheKey, settleDeptIds);
                }
                if (settleDeptIds == null || settleDeptIds.size() <= 0 || settleDeptIds.contains(settleDept.getPkValue())) continue;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u7ed3\u7b97\u90e8\u95e8\u201c%2$s\u201d\u4e0d\u662f\u7ed3\u7b97\u7ec4\u7ec7\u53ef\u7528\u7684\u7ed3\u7b97\u90e8\u95e8\u3002", (String)"OrgValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, settleDept.getString("number")), ErrorLevel.Error);
            }
        }
    }

    private static boolean isCache(Map<String, List<Long>> map, String key) {
        return map.containsKey(key);
    }
}

