/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.enums.PayModeEnum;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.mpscmm.msbd.opplugin.AmountPlanValidator;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;

public class PayInfoValidator
extends AmountPlanValidator {
    public static String PARA_ISCHECKAMOUNTPLAN = "ischeckamountplan";

    public Set<String> preparePropertys() {
        super.setValidation(new HashMap(SalOrderRecPlanHelper.getParaMap()));
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("biztype");
        preparePropertys.add("paymode");
        return preparePropertys;
    }

    public void validate() {
        String customparameter = (String)this.getValidation().get("customparameter");
        super.setValidation(new HashMap(SalOrderRecPlanHelper.getParaMap()));
        if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKAMOUNTPLAN))) {
            super.validate();
        }
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObjectCollection payEntrys;
            DynamicObject bill = extend.getDataEntity();
            String payMode = bill.getString("paymode");
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (billType == null) continue;
            if ("sm_SalesOrder_SERV_BT_S".equals(billType.getString("number")) && PayModeEnum.CASH.getValue().equals(payMode)) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u670d\u52a1\u7c7b\u9500\u552e\u8ba2\u5355\uff0c\u4ed8\u6b3e\u65b9\u5f0f\u5e94\u4e3a\u201c\u8d4a\u9500\u201d\u3002", (String)"PayInfoValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if ("sm_SalesOrder_Agency_BT_S".equals(billType.getString("number")) && PayModeEnum.CASH.getValue().equals(payMode)) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u59d4\u6258\u4ee3\u9500\u8ba2\u5355\uff0c\u4ed8\u6b3e\u65b9\u5f0f\u5e94\u4e3a\u201c\u8d4a\u9500\u201d\u3002", (String)"PayInfoValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if ((payEntrys = bill.getDynamicObjectCollection("recplanentry")) == null || payEntrys.size() <= 0) continue;
            for (int i = 0; i < payEntrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)payEntrys.get(i);
                BigDecimal unRemainAmount = entry.getBigDecimal("r_unremainamount");
                BigDecimal recAmount = entry.getBigDecimal("r_recadvanceamount");
                if (unRemainAmount == null || recAmount == null || unRemainAmount.compareTo(recAmount) <= 0) continue;
                String tipMsg = String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\uff0c\u201c\u672a\u5173\u8054\u6536\u6b3e\u91d1\u989d\u201d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u201c\u6536\u6b3e\u91d1\u989d\u201d\u3002", (String)"PayInfoValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1);
                this.addMessage(extend, tipMsg, ErrorLevel.Error);
            }
        }
    }
}

