/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;

public class SalOrderPreInvoicingValidator
extends AbstractValidator {
    public static Log logger = LogFactory.getLog(SalOrderPreInvoicingValidator.class);

    public void validate() {
        if (this.dataEntities != null) {
            if (this.dataEntities.length > 1) {
                String singlePreTip = String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u5f20\u5355\u636e\u9884\u5f00\u7968\u64cd\u4f5c\u3002", (String)"SalOrderPreInvoicingValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), new Object[0]);
                this.addMessage(this.dataEntities[0], singlePreTip, ErrorLevel.Error);
                return;
            }
            for (ExtendedDataEntity extend : this.dataEntities) {
                this.checkAndGetPreOriginalParamAndWfSet(extend);
            }
        }
    }

    private void checkAndGetPreOriginalParamAndWfSet(ExtendedDataEntity extend) {
        block22: {
            DynamicObject bill = extend.getDataEntity();
            DynamicObjectCollection matEntrys = bill.getDynamicObjectCollection("billentry");
            String noParamTip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u884c\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u65e0\u9884\u5f00\u7968\u65b9\u5f0f\uff0c\u8bf7\u8054\u7cfb\u8d22\u52a1\u4eba\u5458\u3002", (String)"SalOrderPreInvoicingValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), new Object[0]);
            if (matEntrys == null) {
                this.addMessage(extend, noParamTip, ErrorLevel.Error);
                return;
            }
            if (matEntrys.size() > 2000) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u9884\u5f00\u7968\u65f6\uff0c\u7269\u6599\u660e\u7ec6\u884c\u4e0d\u5141\u8bb8\u8d85\u8fc72000\u884c\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"SalOrderPreInvoicingValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            ArrayList<Long> orgIdList = new ArrayList<Long>(16);
            for (DynamicObject row : matEntrys) {
                DynamicObject settleOrg;
                if (row == null || row.getDynamicObject("entrysettleorg") == null || (settleOrg = row.getDynamicObject("entrysettleorg")) == null || orgIdList.contains(settleOrg.getLong("id"))) continue;
                orgIdList.add(settleOrg.getLong("id"));
            }
            if (orgIdList.size() > 0) {
                try {
                    Map paramMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"PreOriginalParamService", (String)"getPreOriginalParam", (Object[])new Object[]{orgIdList});
                    if (paramMap == null || paramMap.size() <= 0) {
                        this.addMessage(extend, noParamTip, ErrorLevel.Error);
                        break block22;
                    }
                    if (paramMap.containsValue("noprestyle")) {
                        String containsNotPreInvoiceTip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u884c\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u65e0\u9884\u5f00\u7968\u65b9\u5f0f\uff0c\u8bf7\u8054\u7cfb\u8d22\u52a1\u4eba\u5458\u3002", (String)"SalOrderPreInvoicingValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), new Object[0]);
                        this.addMessage(extend, containsNotPreInvoiceTip, ErrorLevel.Error);
                        break block22;
                    }
                    if (paramMap.containsValue("onlytax") && paramMap.containsValue("allamount")) {
                        String paramNotSameTip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u884c\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u7684\u9884\u5f00\u7968\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u8d22\u52a1\u4eba\u5458\u3002", (String)"SalOrderPreInvoicingValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), new Object[0]);
                        this.addMessage(extend, paramNotSameTip, ErrorLevel.Error);
                        break block22;
                    }
                    String preInvoiceParam = "";
                    if (paramMap.containsValue("onlytax") && !paramMap.containsValue("allamount")) {
                        preInvoiceParam = "onlytax";
                    } else if (!paramMap.containsValue("onlytax") && paramMap.containsValue("allamount")) {
                        preInvoiceParam = "allamount";
                    } else {
                        this.addMessage(extend, noParamTip, ErrorLevel.Error);
                    }
                    if (!StringUtils.isNotEmpty((String)preInvoiceParam)) break block22;
                    try {
                        Map verifyIsEnable = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"PreOriginalVerifyEnableService", (String)"verifyIsEnalbeValidator", (Object[])new Object[]{preInvoiceParam});
                        if (verifyIsEnable != null) {
                            if (Boolean.TRUE.equals(verifyIsEnable.get("success"))) {
                                this.getOption().setVariableValue("PreOriginalParam", preInvoiceParam);
                            } else if (Boolean.FALSE.equals(verifyIsEnable.get("success")) && StringUtils.isNotEmpty((String)((String)verifyIsEnable.get("message")))) {
                                this.addMessage(extend, (String)verifyIsEnable.get("message"), ErrorLevel.Error);
                            }
                        }
                    }
                    catch (KDException ke1) {
                        String kdExcMsg1 = ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)ke1));
                        logger.info("\u8c03\u7528 \u5e94\u6536 PreOriginalVerifyEnableService\u63a5\u53e3\u6821\u9a8c\u6838\u9500\u914d\u7f6e\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a" + kdExcMsg1);
                        this.addMessage(extend, kdExcMsg1, ErrorLevel.Error);
                    }
                    catch (Exception e1) {
                        String eMsg1 = ExceptionUtils.getExceptionStackTraceMessage((Exception)e1);
                        logger.error("\u8c03\u7528 \u5e94\u6536 PreOriginalVerifyEnableService\u63a5\u53e3\u6821\u9a8c\u6838\u9500\u914d\u7f6e\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a", (Object)eMsg1);
                        this.addMessage(extend, eMsg1, ErrorLevel.Error);
                    }
                }
                catch (KDException ke) {
                    String kdExcMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)ke));
                    logger.info("\u8c03\u7528 \u5e94\u6536 PreOriginalParamService\u63a5\u53e3\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a" + kdExcMsg);
                    this.addMessage(extend, kdExcMsg, ErrorLevel.Error);
                }
                catch (Exception e) {
                    String eMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    logger.error("\u8c03\u7528 \u5e94\u6536 PreOriginalParamService\u63a5\u53e3\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a", (Object)eMsg);
                    this.addMessage(extend, eMsg, ErrorLevel.Error);
                }
            } else {
                this.addMessage(extend, noParamTip, ErrorLevel.Error);
            }
        }
    }
}

