/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.scmc.sm.business.helper.MaterialHelper;

public class SoOtherValidator
extends AbstractValidator {
    private static final String IS_CHECK_CUSTOMER = "ischeckcustomer";
    private static final String IS_CHECK_MATERIAL_TYPE = "ischeckmaterialtype";

    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>();
        }
        prepareProperties.add("org");
        prepareProperties.add("biztype");
        prepareProperties.add("customer");
        prepareProperties.add("pricelist");
        prepareProperties.add("bizdate");
        prepareProperties.add("material");
        return prepareProperties;
    }

    public void validate() {
        Map<String, String> validParams = this.getValidParams();
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject bill = extend.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject priceList = bill.getDynamicObject("pricelist");
            Date bizdate = bill.getDate("bizdate");
            DynamicObject customer = bill.getDynamicObject("customer");
            if (priceList != null) {
                String msg;
                priceList = BusinessDataServiceHelper.loadSingleFromCache((Object)priceList.getPkValue(), (String)"sm_salepricelist", (String)"org,effectdate,expirydate,customerentryentity.customer,customerentryentity.customergroup");
                if (bizdate != null && priceList.getDate("effectdate") != null && priceList.getDate("expirydate") != null && (bizdate.compareTo(priceList.getDate("effectdate")) < 0 || bizdate.compareTo(priceList.getDate("expirydate")) > 0)) {
                    msg = ResManager.loadKDString((String)"\u201c\u8ba2\u5355\u65e5\u671f\u201d\u4e0d\u5728\u201c\u4ef7\u76ee\u8868\u201d\u751f\u6548\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"SoOtherValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                    this.addMessage(extend, msg, ErrorLevel.Error);
                }
                if (customer != null) {
                    HashSet<Long> cusSet = new HashSet<Long>(8);
                    cusSet.add((Long)customer.getPkValue());
                    Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customergroupdetail", (String)"group", (QFilter[])new QFilter[]{new QFilter("customer", "=", customer.getPkValue())});
                    for (DynamicObject groupDetail : objectMap.values()) {
                        DynamicObject group = groupDetail.getDynamicObject("group");
                        if (group == null) continue;
                        cusSet.add((Long)group.getPkValue());
                    }
                    HashSet<Long> priceCusSet = new HashSet<Long>(8);
                    DynamicObjectCollection cusEntrys = priceList.getDynamicObjectCollection("customerentryentity");
                    for (DynamicObject entry : cusEntrys) {
                        DynamicObject customergroup;
                        DynamicObject cutomer = entry.getDynamicObject("customer");
                        if (cutomer != null) {
                            priceCusSet.add((Long)cutomer.getPkValue());
                        }
                        if ((customergroup = entry.getDynamicObject("customergroup")) == null) continue;
                        priceCusSet.add((Long)customergroup.getPkValue());
                    }
                    if (priceCusSet.size() > 0) {
                        cusSet.retainAll(priceCusSet);
                        if (cusSet.isEmpty()) {
                            String msg2 = ResManager.loadKDString((String)"\u201c\u4ef7\u76ee\u8868\u201d\u5ba2\u6237\u6216\u5ba2\u6237\u5206\u7c7b\u4e0e\u201c\u8ba2\u8d27\u5ba2\u6237\u201d\u4e0d\u4e00\u81f4\u3002", (String)"SoOtherValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                            this.addMessage(extend, msg2, ErrorLevel.Error);
                        }
                    }
                }
                if (!org.getPkValue().equals(priceList.getDynamicObject("org").getPkValue())) {
                    msg = ResManager.loadKDString((String)"\u201c\u4ef7\u76ee\u8868\u201d\u9500\u552e\u7ec4\u7ec7\u4e0e\u5355\u636e\u201c\u9500\u552e\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"SoOtherValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                    this.addMessage(extend, msg, ErrorLevel.Error);
                }
            }
            DynamicObject headCustomer = bill.getDynamicObject("customer");
            if (!this.isAgencyType(bill.getDynamicObject("biztype"))) continue;
            if (headCustomer != null && !"false".equals(validParams.get(IS_CHECK_CUSTOMER)) && !this.isEnableConsignCustomer(headCustomer)) {
                this.addErrorMessage(extend, String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u201c%1$s\u201d\u4e0d\u662f\u53ef\u5bc4\u552e\u5ba2\u6237\u3002", (String)"SoOtherValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), headCustomer.getString("number")));
            }
            if ("false".equals(validParams.get(IS_CHECK_MATERIAL_TYPE))) continue;
            this.validateMaterial(extend);
        }
    }

    private void validateMaterial(ExtendedDataEntity extend) {
        DynamicObject bill = extend.getDataEntity();
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null) {
            return;
        }
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            DynamicObject material = row.getDynamicObject("material");
            if (MaterialHelper.isMaterialType((DynamicObject)material, (boolean)false) && MaterialHelper.isEnableConsign((DynamicObject)material, (boolean)false)) continue;
            this.addErrorMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u7269\u6599\u201d\u9700\u4e3a\u53ef\u5bc4\u552e\u7269\u8d44\u7c7b\u7269\u6599\u3002", (String)"SoOtherValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1));
        }
    }

    private boolean isAgencyType(DynamicObject bizType) {
        return bizType != null && "230".equalsIgnoreCase(bizType.getString("number"));
    }

    private Map<String, String> getValidParams() {
        HashMap<String, String> validParams = new HashMap<String, String>(16);
        String customParameter = (String)this.getValidation().get("customparameter");
        List params = MethodParameterUtil.fromJsonString((Object)customParameter);
        if (params != null) {
            for (Map map : params) {
                validParams.put((String)map.get("name"), (String)map.get("val"));
            }
        }
        return validParams;
    }

    private boolean isEnableConsignCustomer(DynamicObject customer) {
        return customer.getBoolean("consignment");
    }
}

