/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.helper.SalesOrgHelper;

public class SupplytransValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("billtype");
        preparePropertys.add("entrysettleorg");
        preparePropertys.add("supplytrans");
        preparePropertys.add("purorg");
        preparePropertys.add("supplier");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject bill = extend.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject billType = bill.getDynamicObject("billtype");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                String msg;
                DynamicObject supplier;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                boolean suplytrans = entry.getBoolean("supplytrans");
                if (suplytrans && !"sm_SalesOrder_STD_BT_S".equalsIgnoreCase(billType.getString("number"))) {
                    String msg2 = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5355\u636e\u7c7b\u578b\u4e0d\u662f\u201c\u6807\u51c6\u9500\u552e\u8ba2\u5355\u201d\u65f6\uff0c\u4f9b\u5e94\u5546\u76f4\u8fd0\u5e94\u4e3a\u201c\u5426\u201d\u3002", (String)"SupplytransValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                    this.addMessage(extend, String.format(msg2, i + 1), ErrorLevel.Error);
                }
                DynamicObject settleOrg = entry.getDynamicObject("entrysettleorg");
                DynamicObject purOrg = entry.getDynamicObject("purorg");
                if (suplytrans) {
                    String msg3;
                    if (purOrg == null) {
                        msg3 = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u4f9b\u5e94\u5546\u76f4\u8fd0\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SupplytransValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                        this.addMessage(extend, String.format(msg3, i + 1), ErrorLevel.Error);
                    } else if (org != null && settleOrg != null && !SalesOrgHelper.checkPurOrg((Long)((Long)org.getPkValue()), (Long)((Long)settleOrg.getPkValue()), (Long)((Long)purOrg.getPkValue()))) {
                        msg3 = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u4f9b\u5e94\u5546\u76f4\u8fd0\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u5e94\u4e3a\u5f53\u524d\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u4e0b\u7684\u91c7\u8d2d\u7ec4\u7ec7\u6216\u5f53\u524d\u9500\u552e\u7ec4\u7ec7\uff08\u5177\u6709\u91c7\u8d2d\u804c\u80fd\uff09\u3002", (String)"SupplytransValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                        this.addMessage(extend, String.format(msg3, i + 1), ErrorLevel.Error);
                    }
                }
                if ((supplier = entry.getDynamicObject("supplier")) != null && purOrg != null) {
                    if ((supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"id,bizfunction,purchasehold,status,enable,supplier_status")).getBoolean("purchasehold")) {
                        msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%2$s\u201d\u5df2\u51bb\u7ed3\u3002", (String)"SupplytransValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                        this.addMessage(extend, String.format(msg, i + 1, supplier.getString("number")), ErrorLevel.Error);
                    }
                    if (supplier.getString("bizfunction") == null || !supplier.getString("bizfunction").contains("1")) {
                        msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%2$s\u201d\u6ca1\u6709\u91c7\u8d2d\u804c\u80fd\u3002", (String)"SupplytransValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                        this.addMessage(extend, String.format(msg, i + 1, supplier.getString("number")), ErrorLevel.Error);
                    }
                }
                if (supplier == null || purOrg != null) continue;
                msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u91c7\u8d2d\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8ba2\u8d27\u4f9b\u5e94\u5546\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"SupplytransValidator_5", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                this.addMessage(extend, String.format(msg, i + 1, supplier.getString("number")), ErrorLevel.Error);
            }
        }
    }
}

