/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.enums.ChangeTypeEnum;

public class TotalDeliverQtyValidator
extends AbstractValidator {
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";

    public void validate() {
        int baseUnitPrecisionType = 4;
        int baseUnitPrecision = 10;
        block0: for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            DynamicObjectCollection entrys = entity.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject billEntry = (DynamicObject)entrys.get(i);
                Date e_deliverDate = billEntry.getDate("deliverydate");
                String billName = entity.getDataEntityType().getName();
                Date bizdate = (Date)entity.get("bizdate");
                if ("sm_xsalorder".equals(billName)) {
                    bizdate = (Date)entity.get("srcbiztime");
                }
                if (e_deliverDate != null && bizdate.after(e_deliverDate)) {
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u660e\u7ec6\u53d1\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8ba2\u5355\u65e5\u671f\u3002", (String)"TotalDeliverQtyValidator_9", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1));
                }
                BigDecimal qty = billEntry.getBigDecimal("qty");
                DynamicObject unit = (DynamicObject)billEntry.get("unit");
                if (unit == null) continue block0;
                baseUnitPrecision = unit.getInt(UNIT_PRECISION);
                baseUnitPrecisionType = BillTplHelper.getRoundMode((DynamicObject)unit);
                qty = qty.setScale(baseUnitPrecision, baseUnitPrecisionType);
                DynamicObjectCollection deliverEntrys = billEntry.getDynamicObjectCollection("orderdeliverentry");
                if (deliverEntrys.size() <= 0) continue;
                BigDecimal sumQty = BigDecimal.ZERO;
                boolean isAllCancel = true;
                for (int j = 0; j < deliverEntrys.size(); ++j) {
                    if (ChangeTypeEnum.CANCEL.getValue().equals(((DynamicObject)deliverEntrys.get(j)).getString("delentrychangetype"))) continue;
                    isAllCancel = false;
                    BigDecimal planQty = ((DynamicObject)deliverEntrys.get(j)).getBigDecimal("d_planqty");
                    if (planQty == null || planQty.compareTo(BigDecimal.ZERO) == 0) {
                        this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c,\u201c\u53d1\u8d27\u8ba1\u5212\u201d\u7b2c%2$s\u884c\u7684\u201c\u8ba1\u5212\u53d1\u8d27\u6570\u91cf\u201d\u3002", (String)"TotalDeliverQtyValidator_10", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, j + 1));
                    } else {
                        sumQty = sumQty.add(planQty);
                    }
                    baseUnitPrecision = unit.getInt(UNIT_PRECISION);
                    baseUnitPrecisionType = BillTplHelper.getRoundMode((DynamicObject)unit);
                    sumQty = sumQty.setScale(baseUnitPrecision, baseUnitPrecisionType);
                    Date deliverDate = ((DynamicObject)deliverEntrys.get(j)).getDate("d_plandeliverydate");
                    Date planDate = ((DynamicObject)deliverEntrys.get(j)).getDate("d_plandate");
                    if (deliverDate == null) {
                        this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c,\u201c\u53d1\u8d27\u8ba1\u5212\u201d\u7b2c%2$s\u884c\u7684\u201c\u8ba1\u5212\u53d1\u8d27\u65e5\u671f\u201d\u3002", (String)"TotalDeliverQtyValidator_7", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, j + 1));
                    }
                    if (planDate == null) {
                        this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c,\u201c\u53d1\u8d27\u8ba1\u5212\u201d\u7b2c%2$s\u884c\u7684\u201c\u8981\u8d27\u65e5\u671f\u201d\u3002", (String)"TotalDeliverQtyValidator_8", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, j + 1));
                    }
                    if (deliverDate == null || planDate == null) continue;
                    if (this.getEntityKey().equals("sm_xsalorder")) {
                        Date srcbiztime = (Date)entity.get("srcbiztime");
                        if (srcbiztime.after(deliverDate)) {
                            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u5bf9\u5e94\u7684\u7b2c%2$s\u884c\u53d1\u8d27\u8ba1\u5212\u5b50\u5206\u5f55\u4e2d\u8ba1\u5212\u53d1\u8d27\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u8ba2\u5355\u65e5\u671f\u3002", (String)"TotalDeliverQtyValidator_6", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, j + 1));
                        }
                    } else if (bizdate.after(deliverDate)) {
                        this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u5bf9\u5e94\u7684\u7b2c%2$s\u884c\u53d1\u8d27\u8ba1\u5212\u5b50\u5206\u5f55\u4e2d\u8ba1\u5212\u53d1\u8d27\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u8ba2\u5355\u65e5\u671f\u3002", (String)"TotalDeliverQtyValidator_6", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, j + 1));
                    }
                    if (!planDate.before(deliverDate)) continue;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6,\u7b2c%2$s\u884c\u53d1\u8d27\u8ba1\u5212\u5b50\u5206\u5f55\u4e2d\u8ba1\u5212\u53d1\u8d27\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u8981\u8d27\u65e5\u671f\u3002", (String)"TotalDeliverQtyValidator_5", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, j + 1));
                }
                if (isAllCancel || qty.compareTo(sumQty) == 0) continue;
                int row = i + 1;
                this.addMessage(extend, MessageFormat.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\u6570\u91cf\u4e0e\u53d1\u8d27\u8ba1\u5212\u603b\u6570\u4e0d\u5339\u914d\uff0c\u6570\u91cf\u4e3a{1}\uff0c\u53d1\u8d27\u603b\u6570\u4e3a{2}\u3002", (String)"TotalDeliverQtyValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + "", qty + "", sumQty + ""));
            }
        }
    }
}

