/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.sdk.scmc.sm.extpoint.IXSalOrderCasePlugin;

public class XSSalOrderValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(XSSalOrderValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"XSSalModelActiveValidator", (String)"validate");){
            Map cancelResult = null;
            try {
                PluginProxy pluginProxy = PluginProxy.create(null, IXSalOrderCasePlugin.class, (String)"SCMC_SM_XSSALORDERBILL_ACTIVE_CANCELCHECK", null);
                List cancelResults = pluginProxy.callReplace(IXSalOrderCasePlugin::cancelCheck);
                if (cancelResults != null && cancelResults.size() > 0) {
                    cancelResult = (Map)cancelResults.get(cancelResults.size() - 1);
                }
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f[%1$s]\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"BillTplHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]);
                msg = String.format(msg, "SCMC_SM_XSSALORDERBILL_ACTIVE_CANCELCHECK");
                String msgTotal = msg + e;
                LOG.info(msgTotal);
                throw new KDBizException(msgTotal);
            }
            if (cancelResult == null || cancelResult.get("QTYCHECKCANCEL") == null || !((Boolean)cancelResult.get("QTYCHECKCANCEL")).booleanValue()) {
                for (ExtendedDataEntity extend : this.dataEntities) {
                    this.checkEntryQty(extend);
                }
            }
            if (cancelResult == null || cancelResult.get("AMOUNTCHECKCANCEL") == null || !((Boolean)cancelResult.get("AMOUNTCHECKCANCEL")).booleanValue()) {
                for (ExtendedDataEntity extend : this.dataEntities) {
                    this.checkEntryAmount(extend);
                }
            }
        }
    }

    private void checkEntryQty(ExtendedDataEntity extend) {
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            if (ChangeTypeEnum.UPDATE.getValue().equals(billEntry.getString("entrychangetype"))) {
                int row;
                BigDecimal baseUpQty = billEntry.getBigDecimal("deliverbaseqtyup");
                BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
                BigDecimal associatedBaseQty = billEntry.getBigDecimal("associatedbaseqty");
                BigDecimal baseArJoinQty = billEntry.getBigDecimal("basearjoinqty");
                BigDecimal basePurJoinQty = billEntry.getBigDecimal("basepurjoinqty");
                BigDecimal transApplyBaseQty = billEntry.getBigDecimal("transapplybaseqty");
                BigDecimal cfmJoinBaseQty = billEntry.getBigDecimal("cfmjoinbaseqty");
                if (baseUpQty.compareTo(associatedBaseQty) < 0) {
                    row = i + 1;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u53d8\u66f4\u540e\u7684\u201c\u53d1\u8d27\u4e0a\u9650\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5173\u8054\u6570\u91cf\u201d\u3002", (String)"XSSalModelActiveValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
                }
                if (baseQty.compareTo(baseArJoinQty) < 0) {
                    row = i + 1;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5173\u8054\u5e94\u6536\u6570\u91cf\u201d\u3002", (String)"XSSalModelActiveValidator_5", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
                }
                if (baseQty.compareTo(basePurJoinQty) < 0) {
                    row = i + 1;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5173\u8054\u91c7\u8d2d\u6570\u91cf\u201d\u3002", (String)"XSSalModelActiveValidator_6", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
                }
                if (baseUpQty.compareTo(transApplyBaseQty) < 0) {
                    row = i + 1;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u53d8\u66f4\u540e\u7684\u201c\u53d1\u8d27\u4e0a\u9650\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5df2\u8c03\u62e8\u7533\u8bf7\u6570\u91cf\u201d\u3002", (String)"XSSalModelActiveValidator_7", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
                }
                if (baseQty.compareTo(cfmJoinBaseQty) < 0) {
                    row = i + 1;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5173\u8054\u786e\u8ba4\u6570\u91cf\u201d\u3002", (String)"XSSalModelActiveValidator_9", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
                }
            } else if (ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("entrychangetype"))) {
                BigDecimal associatedBaseQty = billEntry.getBigDecimal("associatedbaseqty");
                BigDecimal baseArJoinQty = billEntry.getBigDecimal("basearjoinqty");
                BigDecimal basePurJoinQty = billEntry.getBigDecimal("basepurjoinqty");
                BigDecimal transApplyBaseQty = billEntry.getBigDecimal("transapplybaseqty");
                BigDecimal baseBackQty = billEntry.getBigDecimal("basebackqty");
                BigDecimal cfmJoinBaseQty = billEntry.getBigDecimal("cfmjoinbaseqty");
                if (associatedBaseQty.compareTo(BigDecimal.ZERO) > 0 || baseArJoinQty.compareTo(BigDecimal.ZERO) > 0 || basePurJoinQty.compareTo(BigDecimal.ZERO) > 0 || transApplyBaseQty.compareTo(BigDecimal.ZERO) > 0 || baseBackQty.compareTo(BigDecimal.ZERO) > 0 || cfmJoinBaseQty.compareTo(BigDecimal.ZERO) > 0) {
                    int row = i + 1;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u7684\u201c\u5173\u8054\u6570\u91cf\u201d\u6216\u201c\u5173\u8054\u5e94\u6536\u6570\u91cf\u201d\u6216\u201c\u5173\u8054\u786e\u8ba4\u6570\u91cf\u201d\u6216\u201c\u5173\u8054\u91c7\u8d2d\u6570\u91cf\u201d\u6216\u201c\u5df2\u8c03\u62e8\u7533\u8bf7\u6570\u91cf\u201d\u6216\u201c\u5df2\u9000\u5e93\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XSSalModelActiveValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
                }
            }
            DynamicObjectCollection deliverEntrys = billEntry.getDynamicObjectCollection("orderdeliverentry");
            if (deliverEntrys.isEmpty()) continue;
            for (int j = 0; j < deliverEntrys.size(); ++j) {
                BigDecimal actQty;
                if (!ChangeTypeEnum.CANCEL.getValue().equals(((DynamicObject)deliverEntrys.get(j)).getString("delentrychangetype")) || (actQty = ((DynamicObject)deliverEntrys.get(j)).getBigDecimal("d_actqty")).compareTo(BigDecimal.ZERO) <= 0) continue;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u53d1\u8d27\u8ba1\u5212\u7b2c%2$s\u884c\u7684\u201c\u5b9e\u9645\u53d1\u8d27\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XSSalModelActiveValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1, j + 1), ErrorLevel.Error);
            }
        }
    }

    private void checkEntryAmount(ExtendedDataEntity extend) {
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("recplanentry");
        for (int i = 0; i < entrys.size(); ++i) {
            BigDecimal remainAmount;
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            if (!ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("recentrychangetype")) || (remainAmount = billEntry.getBigDecimal("r_remainamount")).compareTo(BigDecimal.ZERO) <= 0) continue;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u7684\u201c\u5173\u8054\u6536\u6b3e\u91d1\u989d\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XSSalModelActiveValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
        }
    }
}

