/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.consts.SalesOrderEntryConst;
import kd.scmc.sm.consts.SalesOrderRecPlanConst;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.sdk.scmc.sm.extpoint.IXSalOrderCasePlugin;

public class XSalActiveValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(XSalActiveValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"XSalActiveValidator", (String)"validate");){
            Map cancelResult = null;
            try {
                PluginProxy pluginProxy = PluginProxy.create(null, IXSalOrderCasePlugin.class, (String)"SCMC_SM_XSSALORDERBILL_ACTIVE_CANCELCHECK", null);
                List cancelResults = pluginProxy.callReplace(IXSalOrderCasePlugin::cancelCheck);
                if (cancelResults != null && cancelResults.size() > 0) {
                    cancelResult = (Map)cancelResults.get(cancelResults.size() - 1);
                }
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f[%1$s]\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"BillTplHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]);
                msg = String.format(msg, "SCMC_SM_XSSALORDERBILL_ACTIVE_CANCELCHECK");
                String msgTotal = msg + e;
                LOG.info(msgTotal);
                throw new KDBizException(msgTotal);
            }
            if (cancelResult == null || cancelResult.get("QTYCHECKCANCEL") == null || !((Boolean)cancelResult.get("QTYCHECKCANCEL")).booleanValue()) {
                List amountFields = SalesOrderRecPlanConst.getJoinAmountFields();
                List qtyFields = SalesOrderEntryConst.getJoinQtyFields();
                ArrayList totalFields = new ArrayList();
                totalFields.addAll(amountFields);
                totalFields.addAll(qtyFields);
                String selectStr = String.join((CharSequence)",", totalFields);
                HashSet<Long> srcBillIDs = new HashSet<Long>(this.dataEntities.length);
                for (ExtendedDataEntity extend : this.dataEntities) {
                    DynamicObject entity = extend.getDataEntity();
                    Long srcBillID = entity.getLong("srcid");
                    srcBillIDs.add(srcBillID);
                }
                DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)"sm_salorder", (String)selectStr, (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIDs)});
                HashMap<Long, DynamicObject> srcBillMap = new HashMap<Long, DynamicObject>(srcBills != null ? srcBills.length : 16);
                if (srcBills != null) {
                    for (DynamicObject srcBill : srcBills) {
                        srcBillMap.put(srcBill.getLong("id"), srcBill);
                    }
                }
                for (ExtendedDataEntity extend : this.dataEntities) {
                    DynamicObject entity = extend.getDataEntity();
                    Long srcBillID = entity.getLong("srcid");
                    DynamicObject srcBill = (DynamicObject)srcBillMap.get(srcBillID);
                    this.checkEntryQty(extend, srcBill);
                }
            }
            if (cancelResult == null || cancelResult.get("AMOUNTCHECKCANCEL") == null || !((Boolean)cancelResult.get("AMOUNTCHECKCANCEL")).booleanValue()) {
                for (ExtendedDataEntity extend : this.dataEntities) {
                    this.checkReceiptAmount(extend);
                }
            }
        }
    }

    private void checkEntryQty(ExtendedDataEntity extend, DynamicObject srcBill) {
        DynamicObjectCollection srcEntrys = srcBill.getDynamicObjectCollection("billentry");
        if (srcEntrys == null || srcEntrys.size() == 0) {
            this.addMessage(extend, ResManager.loadKDString((String)"\u6e90\u8ba2\u5355\u4e0d\u5b58\u5728\u7269\u6599\u660e\u7ec6\uff0c\u65e0\u6cd5\u751f\u6548\u3002", (String)"XSalActiveValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Long, DynamicObject> srcEntryMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject srcEntry : srcEntrys) {
            srcEntryMap.put((Long)srcEntry.getPkValue(), srcEntry);
        }
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject srcEntry;
            Long srcBillEntryId;
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            if (!ChangeTypeEnum.UPDATE.getValue().equals(billEntry.getString("entrychangetype")) || (srcBillEntryId = Long.valueOf(billEntry.getLong("srcbillentryid"))) == null || (srcEntry = (DynamicObject)srcEntryMap.get(srcBillEntryId)) == null) continue;
            BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
            BigDecimal baseUpQty = billEntry.getBigDecimal("deliverbaseqtyup");
            if (srcEntry.getBigDecimal("associatedbaseqty").compareTo(baseUpQty) <= 0 && srcEntry.getBigDecimal("basepurjoinqty").compareTo(baseQty) <= 0 && srcEntry.getBigDecimal("transapplybaseqty").compareTo(baseUpQty) <= 0 && srcEntry.getBigDecimal("cfmjoinbaseqty").compareTo(baseQty) <= 0) continue;
            int row = i + 1;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u8ba2\u5355\u5df2\u6267\u884c\u6570\u91cf\u3002", (String)"XSalActiveValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row));
        }
    }

    private void checkReceiptAmount(ExtendedDataEntity extend) {
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            if (!ChangeTypeEnum.UPDATE.getValue().equalsIgnoreCase(billEntry.getString("entrychangetype"))) continue;
            BigDecimal amountAndTax = billEntry.getBigDecimal("amountandtax");
            BigDecimal arAmount = billEntry.getBigDecimal("aramount");
            if (amountAndTax == null || arAmount == null || amountAndTax.compareTo(arAmount) >= 0) continue;
            int row = i + 1;
            String tips = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u4ef7\u7a0e\u5408\u8ba1\u5c0f\u4e8e\u5e94\u6536\u91d1\u989d\uff0c\u4e0d\u80fd\u751f\u6548\u3002", (String)"XSalActiveValidator_7", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row);
            this.addMessage(extend, tips);
        }
    }
}

