/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.quote;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.common.enums.PriceModelEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.enums.ProductTypeEnum;

public class PriceMustInputValidator
extends AbstractValidator {
    public void validate() {
        boolean isKitSale = KitSalesHelper.isKitSale();
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            Boolean isTax = (Boolean)entity.get("istax");
            DynamicObjectCollection entrys = entity.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
                BigDecimal price = entry.getBigDecimal("price");
                String productType = entry.getString("producttype");
                String priceModel = entry.getString("pricemodel");
                if (isKitSale && (ProductTypeEnum.KITPARENT.getValue().equals(productType) && PriceModelEnum.CHILD.getValue().equals(priceModel) || ProductTypeEnum.KITCHILD.getValue().equals(productType) && PriceModelEnum.PARENT.getValue().equals(priceModel))) continue;
                if (Boolean.TRUE.equals(isTax) && BigDecimalUtil.isBlank((BigDecimal)priceAndTax)) {
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%s\u884c\u7684\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"PriceMustInputValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
                if (!Boolean.FALSE.equals(isTax) || !BigDecimalUtil.isBlank((BigDecimal)price)) continue;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%s\u884c\u7684\u201c\u5355\u4ef7\u201d\u3002", (String)"PriceMustInputValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
            }
        }
    }
}

