/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.quote;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class QuotationDateValidator
extends AbstractValidator {
    public static final String BIZDATE = "bizdate";
    public static final String EFFECTDATE = "effectdate";
    public static final String EXPIRYDATE = "expirydate";

    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            Date pricedate = (Date)entity.get(BIZDATE);
            Date effectdate = (Date)entity.get(EFFECTDATE);
            Date expirydate = (Date)entity.get(EXPIRYDATE);
            if (effectdate == null || pricedate == null || expirydate == null) continue;
            if (effectdate.compareTo(pricedate) < 0) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u62a5\u4ef7\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"QuotationDateValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (effectdate.compareTo(expirydate) <= 0) continue;
            this.addMessage(extend, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"QuotationDateValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

