/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.returnap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class SaleReturnApplyOtherValidator
extends AbstractValidator {
    private static final String IS_CHECK_MATERIAL = "ischeckmaterial";
    private static final String IS_CHECK_INSPECT_ORG = "ischeckinspectorg";
    private static final String IS_CHECK_ENTRY_SETTLE_ORG = "ischeckentrysettleorg";
    private static final String IS_CHECK_ENTRY_INV_ORG = "ischeckentryinvorg";
    private static final String IS_CHECK_PRODUCT_TYPE = "ischeckproducttype";
    private final Map<String, List<Long>> orgCache = new HashMap<String, List<Long>>(32);

    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>();
        }
        prepareProperties.add("biztype");
        prepareProperties.add("material");
        prepareProperties.add("entryinvorg");
        prepareProperties.add("inspectorg");
        prepareProperties.add("producttype");
        prepareProperties.add("entrysettleorg");
        prepareProperties.add("org");
        return prepareProperties;
    }

    public void validate() {
        Map<String, String> validParams = this.getValidParams();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject saleOrg;
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isVmi = false;
            DynamicObject bizType = bill.getDynamicObject("biztype");
            if (bizType != null && "6".equals(bizType.getString("domain"))) {
                isVmi = true;
            }
            Long saleOrgId = (saleOrg = bill.getDynamicObject("org")) == null ? Long.valueOf(0L) : (Long)saleOrg.getPkValue();
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            if (entries == null) continue;
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject row = (DynamicObject)entries.get(i);
                if (!"false".equals(validParams.get(IS_CHECK_MATERIAL))) {
                    this.validateMaterial(dataEntity, row, i, isVmi);
                }
                if (!"false".equals(validParams.get(IS_CHECK_INSPECT_ORG))) {
                    this.validateInspectOrg(dataEntity, row, i);
                }
                if (!"false".equals(validParams.get(IS_CHECK_ENTRY_SETTLE_ORG))) {
                    this.validateEntrySettleOrg(saleOrgId, dataEntity, row, i);
                }
                if (!"false".equals(validParams.get(IS_CHECK_ENTRY_INV_ORG))) {
                    this.validateEntryInvOrg(saleOrgId, dataEntity, row, i);
                }
                if ("false".equals(validParams.get(IS_CHECK_PRODUCT_TYPE))) continue;
                this.validateProductType(dataEntity, row, i);
            }
        }
    }

    private Map<String, String> getValidParams() {
        HashMap<String, String> validParams = new HashMap<String, String>(16);
        String customParameter = (String)this.getValidation().get("customparameter");
        List params = MethodParameterUtil.fromJsonString((Object)customParameter);
        if (params != null) {
            for (Map map : params) {
                validParams.put((String)map.get("name"), (String)map.get("val"));
            }
        }
        return validParams;
    }

    private void validateMaterial(ExtendedDataEntity dataEntity, DynamicObject row, int rowIndex, boolean isVmi) {
        String tipMsg;
        DynamicObject materialSalInfo = row.getDynamicObject("material");
        if (materialSalInfo == null) {
            return;
        }
        DynamicObject material = materialSalInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        if (isVmi && !material.getBoolean("enablevmi")) {
            tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u4e1a\u52a1\u7c7b\u578b\u9886\u57df\u4e3aVMI,\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u4e0d\u662f\u53efVMI\u7684\u7269\u6599\u3002", (String)"SaleReturnApplyOtherValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), rowIndex + 1, materialSalInfo.getDynamicObject("masterid").getString("number"));
            this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
        }
        if (material.getBoolean("suite") || StringUtils.isNotEmpty((String)materialSalInfo.getString("pricemodel")) || StringUtils.isNotEmpty((String)materialSalInfo.getString("kittransfermodel")) || StringUtils.isNotEmpty((String)materialSalInfo.getString("kitreturnmodel")) || StringUtils.isNotEmpty((String)materialSalInfo.getString("kitstructctl"))) {
            tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c%2$s\uff08%3$s\uff09\u7269\u6599\u7684\u5957\u4ef6\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u7269\u6599\u9500\u552e\u4fe1\u606f\u4e2d\u5b9a\u4ef7\u65b9\u5f0f\u3001\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u3001\u5957\u4ef6\u9000\u8d27\u65b9\u5f0f\u3001\u5355\u636e\u5957\u4ef6\u7ed3\u6784\u63a7\u5236\u90fd\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"SaleReturnApplyOtherValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), rowIndex + 1, material.getString("name"), material.getString("number"));
            this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
        }
    }

    private void validateInspectOrg(ExtendedDataEntity dataEntity, DynamicObject row, int rowIndex) {
        DynamicObject entryInvOrg = row.getDynamicObject("entryinvorg");
        DynamicObject inspectOrg = row.getDynamicObject("inspectorg");
        if (entryInvOrg != null && inspectOrg != null) {
            Long entryInvOrgId = (Long)entryInvOrg.getPkValue();
            String key = entryInvOrgId + "entryinvorg";
            List<Long> inspectOrgIds = this.orgCache.get(key);
            if (inspectOrgIds == null || inspectOrgIds.isEmpty()) {
                inspectOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)entryInvOrgId, (String)"", (String)"06", (String)"toorg");
                if (inspectOrgIds.isEmpty()) {
                    inspectOrgIds = this.getAllValidSettleOrg(dataEntity, "06");
                }
                this.orgCache.put(key, inspectOrgIds);
            }
            if (!inspectOrgIds.isEmpty() && !inspectOrgIds.contains((Long)inspectOrg.getPkValue())) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d1\u8d27\u7ec4\u7ec7\u201c%2$s\u201d\uff0c\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"SaleReturnApplyOtherValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), rowIndex + 1, entryInvOrg.getString("number")));
            }
        }
    }

    private void validateEntrySettleOrg(Long saleOrgId, ExtendedDataEntity dataEntity, DynamicObject row, int rowIndex) {
        DynamicObject entrySettleOrg = row.getDynamicObject("entrysettleorg");
        if (entrySettleOrg != null) {
            Long entrySettleOrgId = (Long)entrySettleOrg.getPkValue();
            String key = saleOrgId + "entrysettleorg";
            List<Long> settleOrgIds = this.orgCache.get(key);
            if (settleOrgIds == null || settleOrgIds.isEmpty()) {
                settleOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)saleOrgId, (String)"03", (String)"10", (String)"toorg");
                if (settleOrgIds.isEmpty()) {
                    settleOrgIds = this.getAllValidSettleOrg(dataEntity, "10");
                }
                this.orgCache.put(key, settleOrgIds);
            }
            if (!settleOrgIds.isEmpty() && !settleOrgIds.contains(entrySettleOrgId)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7ed3\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"SaleReturnApplyOtherValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), rowIndex + 1, entrySettleOrg.getString("number")));
            }
        }
    }

    private void validateEntryInvOrg(Long saleOrgId, ExtendedDataEntity dataEntity, DynamicObject row, int rowIndex) {
        DynamicObject entryInvOrg = row.getDynamicObject("entryinvorg");
        if (entryInvOrg != null) {
            Long entryInvOrgId = (Long)entryInvOrg.getPkValue();
            String key = saleOrgId + "entryinvorg";
            List<Long> invOrgIds = this.orgCache.get(key);
            if (invOrgIds == null || invOrgIds.isEmpty()) {
                invOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)saleOrgId, (String)"03", (String)"05", (String)"toorg");
                if (invOrgIds.isEmpty()) {
                    invOrgIds = this.getAllValidSettleOrg(dataEntity, "05");
                }
                this.orgCache.put(key, invOrgIds);
            }
            if (!invOrgIds.isEmpty() && !invOrgIds.contains(entryInvOrgId)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"SaleReturnApplyOtherValidator_5", (String)"scmc-sm-opplugin", (Object[])new Object[0]), rowIndex + 1, entryInvOrg.getString("number")));
            }
        }
    }

    private List<Long> getAllValidSettleOrg(ExtendedDataEntity dataEntity, String orgViewType) {
        return kd.scmc.sm.business.helper.OrgHelper.getHasPermissionOrg((String)dataEntity.getDataEntity().getDataEntityType().getName(), (String)orgViewType);
    }

    private void validateProductType(ExtendedDataEntity dataEntity, DynamicObject row, int rowIndex) {
        String productType = row.getString("producttype");
        if ("kitparent".equals(productType) || "kitchild".equals(productType)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u4ea7\u54c1\u7c7b\u522b\u4e0d\u80fd\u662f\u5957\u4ef6\u7236\u9879\u6216\u5957\u4ef6\u5b50\u9879\u3002", (String)"SaleReturnApplyOtherValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), rowIndex + 1));
        }
    }
}

