/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.tpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.enums.ProductTypeEnum;

public class KitSalesKitQtyValidator
extends AbstractValidator {
    public void validate() {
        String productType;
        QFilter entryFilter;
        DynamicObject[] srcOrders;
        DynamicObjectCollection billEntrys;
        if (!KitSalesHelper.isKitSale()) {
            return;
        }
        HashSet<Long> srcOrderIds = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> srcOrderEntryMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Integer> srcOrderKitChildNumMap = new HashMap<Long, Integer>(16);
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject bill = extend.getDataEntity();
            billEntrys = bill.getDynamicObjectCollection("billentry");
            if (billEntrys == null || billEntrys.isEmpty()) continue;
            for (Object row : billEntrys) {
                String productType2 = row.getString("producttype");
                String kitTransferModel = row.getString("kittransfermodel");
                if (!ProductTypeEnum.KITCHILD.getValue().equals(productType2) || !KitTransferModelEnum.KIT.getValue().equals(kitTransferModel)) continue;
                Long srcOrderId = row.getLong("srcbillid");
                Long srcOrderEntryId = row.getLong("srcbillentryid");
                String srcBillEntity = row.getString("srcbillentity");
                if (!"sm_salorder".equals(srcBillEntity) || srcOrderId == null || srcOrderEntryId == null) continue;
                srcOrderIds.add(srcOrderId);
            }
        }
        if (!srcOrderIds.isEmpty() && (srcOrders = BusinessDataServiceHelper.load((String)"sm_salorder", (String)"id,billentry.id,billentry.linetype,billentry.producttype,billentry.kitqty,billentry.parentqty,billentry.kitpid", (QFilter[])new QFilter[]{entryFilter = new QFilter("id", "in", srcOrderIds)})) != null && srcOrders.length > 0) {
            for (DynamicObject srcOrder : srcOrders) {
                DynamicObjectCollection srcOrderEntrys = srcOrder.getDynamicObjectCollection("billentry");
                if (srcOrderEntrys == null || srcOrderEntrys.isEmpty()) continue;
                for (DynamicObject srcOrderEntry : srcOrderEntrys) {
                    Long srcOrderEntryId = (Long)srcOrderEntry.getPkValue();
                    productType = srcOrderEntry.getString("producttype");
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType) || ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                        srcOrderEntryMap.put(srcOrderEntryId, srcOrderEntry);
                    }
                    if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                    List<DynamicObject> childRowList = this.getAllChildRows(srcOrderEntry, srcOrderEntrys);
                    srcOrderKitChildNumMap.put(srcOrderEntryId, childRowList.size());
                }
            }
        }
        for (ExtendedDataEntity extend : this.dataEntities) {
            Long pId;
            String kitTransferModel;
            DynamicObject bill = extend.getDataEntity();
            billEntrys = bill.getDynamicObjectCollection("billentry");
            if (billEntrys == null || billEntrys.isEmpty()) continue;
            HashSet<Long> parentRowPidSet = new HashSet<Long>(16);
            int i = 0;
            block5: for (DynamicObject row : billEntrys) {
                ++i;
                productType = row.getString("producttype");
                kitTransferModel = row.getString("kittransfermodel");
                if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || !KitTransferModelEnum.KIT.getValue().equals(kitTransferModel)) continue;
                pId = row.getLong("kitpid");
                parentRowPidSet.add(pId);
                Long srcOrderId = row.getLong("srcbillid");
                Long srcOrderEntryId = row.getLong("srcbillentryid");
                String srcBillEntity = row.getString("srcbillentity");
                if (!"sm_salorder".equals(srcBillEntity) || srcOrderId == null || srcOrderEntryId == null) continue;
                BigDecimal parentBaseQty = row.getBigDecimal("baseqty");
                DynamicObject parentMaterial = row.getDynamicObject("material");
                String parentMaterialCode = KitSalesHelper.getMaterialCode((DynamicObject)parentMaterial);
                String parentMaterialName = KitSalesHelper.getMaterialName((DynamicObject)parentMaterial);
                List<DynamicObject> allChildRows = this.getAllChildRows(row, billEntrys);
                if (srcOrderKitChildNumMap.get(srcOrderEntryId) != null && ((Integer)srcOrderKitChildNumMap.get(srcOrderEntryId)).intValue() != allChildRows.size()) {
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u5957\u4ef6\u7236\u9879\u7269\u6599%2$s\uff08%3$s\uff09\u548c\u5bf9\u5e94\u7684\u5b50\u9879\u4e0d\u6210\u5957\uff0c\u8bf7\u8c03\u6574\u3002", (String)"KitSalesKitQtyValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i, parentMaterialName, parentMaterialCode), ErrorLevel.Error);
                    continue;
                }
                if (allChildRows.isEmpty()) continue;
                for (DynamicObject childRow : allChildRows) {
                    BigDecimal oldQty;
                    Boolean storageOut;
                    DynamicObject childRowLineType;
                    DynamicObject childSrcOrderEntry;
                    Long childSrcOrderEntryId = childRow.getLong("srcbillentryid");
                    if (childSrcOrderEntryId == null || (childSrcOrderEntry = (DynamicObject)srcOrderEntryMap.get(childSrcOrderEntryId)) == null) continue;
                    BigDecimal childRowKitQty = childSrcOrderEntry.getBigDecimal("kitqty");
                    BigDecimal childRowParentQty = childSrcOrderEntry.getBigDecimal("parentqty");
                    DynamicObject childRowBaseUnit = childRow.getDynamicObject("baseunit");
                    DynamicObject childRowMaterial = childRow.getDynamicObject("material");
                    DynamicObject childRowUnit = childRow.getDynamicObject("unit");
                    if (parentBaseQty == null || parentBaseQty.compareTo(BigDecimal.ZERO) == 0 || childRowParentQty == null || childRowParentQty.compareTo(BigDecimal.ZERO) == 0 || childRowKitQty == null || childRowUnit == null || childRowBaseUnit == null || childRowMaterial == null || (childRowLineType = childRow.getDynamicObject("linetype")) != null && childRowLineType.containsProperty("storageout") && !(storageOut = Boolean.valueOf(childRowLineType.getBoolean("storageout"))).booleanValue()) continue;
                    DynamicObject childRowMasterMaterial = childRowMaterial.getDynamicObject("masterid");
                    int childRowPrecision = KitSalesHelper.getUnitPrecision((DynamicObject)childRowBaseUnit);
                    RoundingMode childRowRoundingMode = KitSalesHelper.getUnitRoundingMode((DynamicObject)childRowBaseUnit);
                    BigDecimal childRowBaseQty = parentBaseQty.multiply(childRowKitQty).divide(childRowParentQty, childRowPrecision, childRowRoundingMode);
                    BigDecimal childRowQty = BillTplHelper.getDesQtyConv((DynamicObject)childRowMasterMaterial, (DynamicObject)childRowBaseUnit, (BigDecimal)childRowBaseQty, (DynamicObject)childRowUnit);
                    if (childRowQty.compareTo(oldQty = childRow.getBigDecimal("qty")) == 0) continue;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u5957\u4ef6\u7236\u9879\u7269\u6599%2$s\uff08%3$s\uff09\u548c\u5bf9\u5e94\u7684\u5b50\u9879\u4e0d\u6210\u5957\uff0c\u8bf7\u8c03\u6574\u3002", (String)"KitSalesKitQtyValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i, parentMaterialName, parentMaterialCode), ErrorLevel.Error);
                    continue block5;
                }
            }
            i = 0;
            for (DynamicObject row : billEntrys) {
                ++i;
                productType = row.getString("producttype");
                kitTransferModel = row.getString("kittransfermodel");
                if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || !KitTransferModelEnum.KIT.getValue().equals(kitTransferModel)) continue;
                pId = row.getLong("kitpid");
                if (!parentRowPidSet.isEmpty() && parentRowPidSet.contains(pId)) continue;
                DynamicObject material = row.getDynamicObject("material");
                String materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                String materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c%2$s\uff08%3$s\uff09\u7f3a\u5c11\u5bf9\u5e94\u7684\u7236\u9879\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"KitSalesKitQtyValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i, materialName, materialCode), ErrorLevel.Error);
            }
        }
    }

    private List<DynamicObject> getAllChildRows(DynamicObject parentRow, DynamicObjectCollection entrys) {
        ArrayList<DynamicObject> allChildRows = new ArrayList<DynamicObject>(16);
        if (parentRow == null || entrys == null || entrys.isEmpty()) {
            return allChildRows;
        }
        Long parentPID = parentRow.getLong("kitpid");
        for (DynamicObject billEntry : entrys) {
            Long pID = billEntry.getLong("kitpid");
            String productType = billEntry.getString("producttype");
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPID.longValue() != pID.longValue()) continue;
            Boolean storageOut = Boolean.TRUE;
            DynamicObject childRowLineType = billEntry.getDynamicObject("linetype");
            if (childRowLineType != null && childRowLineType.containsProperty("storageout")) {
                storageOut = childRowLineType.getBoolean("storageout");
            }
            if (!storageOut.booleanValue()) continue;
            allChildRows.add(billEntry);
        }
        return allChildRows;
    }
}

