/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.tpl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;

public class KitSalesOwnerValidator
extends AbstractValidator {
    public void validate() {
        if (!KitSalesHelper.isKitSale()) {
            return;
        }
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("billentry");
            if (entry.size() <= 0) continue;
            int i = 0;
            for (DynamicObject row : entry) {
                ++i;
                String productType = row.getString("producttype");
                DynamicObject material = row.getDynamicObject("material");
                String materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                String materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) && !ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
                Boolean isValidate = Boolean.TRUE;
                if (this.getEntityKey().equals("sm_xsalorder") || this.getEntityKey().equals("sm_xssalorder")) {
                    String changeType = row.getString("entrychangetype");
                    if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                        isValidate = Boolean.FALSE;
                    }
                }
                if (!isValidate.booleanValue()) continue;
                DynamicObject entrySettleOrg = row.getDynamicObject("entrysettleorg");
                DynamicObject owner = row.getDynamicObject("owner");
                if (entrySettleOrg == null || owner == null || ((Long)entrySettleOrg.getPkValue()).longValue() == ((Long)owner.getPkValue()).longValue()) continue;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u5957\u4ef6\u9500\u552e\u4e1a\u52a1\u6682\u4e0d\u652f\u6301\u7ec4\u7ec7\u95f4\u7ed3\u7b97\uff0c\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u548c\u201c\u8d27\u4e3b\u201d\u8bf7\u4fdd\u6301\u4e00\u81f4\u3002", (String)"KitSalesOwnerValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i, materialName, materialCode), ErrorLevel.Error);
            }
        }
    }
}

