/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.validator.tpl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;

public class KitSalesValidator
extends AbstractValidator {
    public void validate() {
        if (!KitSalesHelper.isKitSale()) {
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObject entity = extend.getDataEntity();
                DynamicObjectCollection entry = entity.getDynamicObjectCollection("billentry");
                if (entry.size() <= 0) continue;
                for (DynamicObject row : entry) {
                    String productType = row.getString("producttype");
                    if (!StringUtils.isEmpty((CharSequence)productType)) continue;
                    row.set("producttype", (Object)ProductTypeEnum.STANDARD.getValue());
                }
            }
            return;
        }
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity = extend.getDataEntity();
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("billentry");
            if (this.getEntityKey().equals("sm_returnapply") && KitSalesHelper.isDraw((String)"sm_returnapply", (DynamicObject)entity) || entry.size() <= 0) continue;
            int i = 0;
            for (DynamicObject row : entry) {
                ++i;
                String productType = row.getString("producttype");
                if (StringUtils.isEmpty((CharSequence)productType)) {
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\u7684\u201c\u4ea7\u54c1\u7c7b\u522b\u201d\u3002", (String)"KitSalesValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i), ErrorLevel.Error);
                    continue;
                }
                DynamicObject material = row.getDynamicObject("material");
                String materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                String materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                if (this.getEntityKey().equals("sm_xsalorder") || this.getEntityKey().equals("sm_xssalorder")) {
                    if (this.hasKitChildXOrder(row, entry)) continue;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u8bf7\u7ef4\u62a4\u5957\u4ef6\u7236\u9879\u7684\u5b50\u9879\u4ea7\u54c1\u3002", (String)"KitSalesValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i, materialName, materialCode), ErrorLevel.Error);
                    continue;
                }
                if (this.hasKitChild(row, entry)) continue;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u8bf7\u7ef4\u62a4\u5957\u4ef6\u7236\u9879\u7684\u5b50\u9879\u4ea7\u54c1\u3002", (String)"KitSalesValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), i, materialName, materialCode), ErrorLevel.Error);
            }
        }
    }

    private boolean hasKitChild(DynamicObject parentRow, DynamicObjectCollection entrys) {
        if (parentRow == null || entrys == null) {
            return false;
        }
        Long parentId = parentRow.getLong("kitpid");
        if (parentId == null) {
            return false;
        }
        for (DynamicObject childRow : entrys) {
            String productType = childRow.getString("producttype");
            Long pid = childRow.getLong("kitpid");
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || !parentId.equals(pid)) continue;
            return true;
        }
        return false;
    }

    private boolean hasKitChildXOrder(DynamicObject parentRow, DynamicObjectCollection entrys) {
        if (parentRow == null || entrys == null) {
            return false;
        }
        String entryChangeType = parentRow.getString("entrychangetype");
        if (ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) {
            return true;
        }
        Long parentId = parentRow.getLong("kitpid");
        if (parentId == null) {
            return false;
        }
        for (DynamicObject childRow : entrys) {
            String productType = childRow.getString("producttype");
            Long pid = childRow.getLong("kitpid");
            String childEntryChangeType = childRow.getString("entrychangetype");
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || !parentId.equals(pid) || ChangeTypeEnum.CANCEL.getValue().equals(childEntryChangeType)) continue;
            return true;
        }
        return false;
    }
}

