/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.events.ChangeData;

public class CommonUtils {
    private CommonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).isEmpty()) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    public static boolean isRealChanged(ChangeData changeSet) {
        if (changeSet == null) {
            return false;
        }
        Object oldObject = changeSet.getOldValue();
        Object newObject = changeSet.getNewValue();
        return CommonUtils.isRealChanged(oldObject, newObject);
    }

    public static boolean isRealChanged(Object oldObject, Object newObject) {
        if (oldObject == null && newObject == null) {
            return true;
        }
        if (oldObject == null) {
            return true;
        }
        if (newObject == null) {
            return true;
        }
        if (oldObject instanceof BigDecimal) {
            if (newObject instanceof BigDecimal && ((BigDecimal)oldObject).compareTo((BigDecimal)newObject) != 0) {
                return true;
            }
            if (newObject instanceof String && ((BigDecimal)oldObject).compareTo(new BigDecimal(newObject.toString())) != 0) {
                return true;
            }
        } else if (oldObject.getClass().isAssignableFrom(newObject.getClass())) {
            if (newObject instanceof DynamicObject) {
                if (!((DynamicObject)newObject).getPkValue().equals(((DynamicObject)oldObject).getPkValue())) {
                    return true;
                }
            } else if (newObject instanceof OrmLocaleValue) {
                if (!((OrmLocaleValue)oldObject).getLocaleValue().equals(((OrmLocaleValue)newObject).getLocaleValue())) {
                    return true;
                }
            } else {
                return !oldObject.equals(newObject);
            }
        }
        return false;
    }

    public static <T> List<List<T>> partition(List<T> originalList, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(16);
        if (originalList == null) {
            return result;
        }
        int remainder = originalList.size() % batchSize;
        int number = originalList.size() / batchSize;
        for (int i = 0; i < number; ++i) {
            List<T> value = originalList.subList(i * batchSize, (i + 1) * batchSize);
            result.add(value);
        }
        if (remainder > 0) {
            result.add(originalList.subList(number * batchSize, originalList.size()));
        }
        return result;
    }
}

