/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.pojo.KitStructureResultInfo;
import kd.scmc.sm.mservice.SalService;

public class SalServiceImpl
implements SalService {
    private static final Log log = LogFactory.getLog(SalServiceImpl.class);

    public boolean wbPrePaidAmount(List<Map<String, Object>> list) {
        DynamicObject[] loads;
        if (list == null || list.size() <= 0) {
            log.info("(\u9884)\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u8ba2\u5355\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a\u3002");
            return false;
        }
        if (list.size() < 300) {
            log.info("(\u9884)\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u8ba2\u5355\u63a5\u53e3\u53c2\u6570:-->" + list);
        }
        ArrayList<Long> ids = new ArrayList<Long>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject[] map = list.get(i);
            if (map == null) continue;
            if ((Long)map.get("sourcepk") != 0L) {
                ids.add((Long)map.get("sourcepk"));
                continue;
            }
            ids.add((Long)map.get("corebillid"));
        }
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"sm_salorder").getDynamicObjectType())) {
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> map = list.get(i);
                if (map == null) {
                    return false;
                }
                Long mainBillId = (Long)map.get("sourcepk");
                Long corebillid = (Long)map.get("corebillid");
                if ((mainBillId == 0L || !mainBillId.equals((Long)load.getPkValue())) && (corebillid == 0L || !corebillid.equals((Long)load.getPkValue()))) continue;
                Long entryId = (Long)map.get("sourceentrypk");
                BigDecimal paidAmount = (BigDecimal)map.get("amount");
                String coreBillType = (String)map.get("corebilltype");
                Boolean bizType = (Boolean)map.get("biztype");
                Boolean confirmLogo = (Boolean)map.get("confirmlogo");
                if (mainBillId == 0L && corebillid == 0L || entryId == 0L || paidAmount == null) {
                    return false;
                }
                if (load == null) {
                    log.info("(\u9884)\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u8ba2\u5355id:-->" + mainBillId + "\u4e0d\u5b58\u5728\u3002");
                    return false;
                }
                if (corebillid != 0L && confirmLogo != null && confirmLogo.booleanValue() && coreBillType != null && coreBillType.equals("sm_salorder")) {
                    if (bizType != null && bizType.booleanValue()) {
                        load.set("prereceiptamount", (Object)load.getBigDecimal("prereceiptamount").add(paidAmount));
                    }
                    load.set("receiptamount", (Object)load.getBigDecimal("receiptamount").add(paidAmount));
                    continue;
                }
                DynamicObjectCollection planDy = load.getDynamicObjectCollection("recplanentry");
                this.setAmount(load, entryId, planDy, paidAmount);
            }
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])loads);
        return true;
    }

    public boolean wbPaidAmount(List<Map<String, Object>> list) {
        if (list == null || list.size() <= 0) {
            log.info("\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u8ba2\u5355\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        if (list.size() < 300) {
            log.info("(\u9884)\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u8ba2\u5355\u63a5\u53e3\u53c2\u6570:-->" + list);
        }
        int size = list.size();
        ArrayList<Long> ids = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = list.get(i);
            if (map == null) continue;
            ids.add((Long)map.get("mainbillid"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"sm_salorder", (String)"id,receiptamount,entrysettleorg", (QFilter[])filters);
        if (loads == null || loads.length == 0) {
            log.info("\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u8ba2\u5355\u63a5\u53e3\u53c2\u6570\u4e2d\u7684\u9500\u552e\u8ba2\u5355ID(mainbillid)\u4e0d\u5b58\u5728:-->" + this.toString(ids));
            return false;
        }
        for (DynamicObject load : loads) {
            for (int i = 0; i < list.size(); ++i) {
                Long mainBillId;
                Map<String, Object> map = list.get(i);
                if (map == null || (mainBillId = (Long)map.get("mainbillid")) == null || !mainBillId.equals((Long)load.getPkValue())) continue;
                BigDecimal paidAmount = (BigDecimal)map.get("paidamount");
                Boolean confirmLogo = (Boolean)map.get("confirmlogo");
                if (mainBillId == null || paidAmount == null) continue;
                BigDecimal oldPaidAmount = load.getBigDecimal("receiptamount");
                if (oldPaidAmount == null) {
                    oldPaidAmount = BigDecimal.ZERO;
                }
                if (confirmLogo != null && confirmLogo.booleanValue()) continue;
                Long mainBillEntryId = (Long)map.get("mainbillentryid");
                Long paramSettleOrg = (Long)map.get("orgid");
                if (paramSettleOrg != null && mainBillEntryId != null) {
                    boolean flag = false;
                    DynamicObjectCollection billEntry = load.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : billEntry) {
                        Long entryId;
                        if (entry == null || !mainBillEntryId.equals(entryId = (Long)entry.getPkValue())) continue;
                        DynamicObject entrySettleOrg = entry.getDynamicObject("entrysettleorg");
                        if (entrySettleOrg == null || paramSettleOrg.equals((Long)entrySettleOrg.getPkValue())) break;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                }
                load.set("receiptamount", (Object)oldPaidAmount.add(paidAmount));
            }
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])loads);
        return true;
    }

    private String toString(List list) {
        StringBuilder builder = new StringBuilder();
        list.forEach(e -> builder.append(e));
        return builder.toString();
    }

    private void setAmount(DynamicObject dyn, Long entryId, DynamicObjectCollection planDy, BigDecimal sAmount) {
        for (DynamicObject row : planDy) {
            if (row.getLong("id") != entryId.longValue()) continue;
            BigDecimal amount = row.getBigDecimal("r_recamount");
            row.set("r_recamount", (Object)amount.add(sAmount));
            dyn.set("prereceiptamount", (Object)dyn.getBigDecimal("prereceiptamount").add(sAmount));
            break;
        }
    }

    public String expandKitStructure(List<Map<String, Object>> parameters) {
        HashMap<Long, KitStructureResultInfo> resultMap = new HashMap<Long, KitStructureResultInfo>();
        log.info("SalServiceImpl expandKitStructure start : " + JSON.toJSONString(parameters));
        for (Map<String, Object> parameter : parameters) {
            String msg;
            KitStructureResultInfo resultInfo = new KitStructureResultInfo();
            Object billEntityObject = parameter.get("billEntity");
            Object billIdObject = parameter.get("billId");
            Object billEntryIdObject = parameter.get("billEntryId");
            Object baseQtyObject = parameter.get("baseQty");
            if (billEntityObject == null || billIdObject == null || billEntryIdObject == null) {
                resultInfo.setStatusFail();
                String msg2 = ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3001\u6838\u5fc3\u5355\u636eID\u3001\u6838\u5fc3\u5355\u636e\u884cID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalServiceImpl_0", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                resultInfo.setMessage(msg2);
                resultMap.put(0L, resultInfo);
                continue;
            }
            BigDecimal baseQty = BigDecimal.ZERO;
            if (!(billEntryIdObject instanceof Long)) {
                resultInfo.setStatusFail();
                msg = ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u884cID\u683c\u5f0f\u9519\u8bef\u3002", (String)"SalServiceImpl_3", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                resultInfo.setMessage(msg);
                resultMap.put(0L, resultInfo);
                continue;
            }
            Long billEntryId = (Long)billEntryIdObject;
            if (!(billEntityObject instanceof String)) {
                resultInfo.setStatusFail();
                msg = ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u683c\u5f0f\u9519\u8bef\u3002", (String)"SalServiceImpl_1", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                resultInfo.setMessage(msg);
                resultMap.put(billEntryId, resultInfo);
                continue;
            }
            String billEntity = (String)billEntityObject;
            if (!(billIdObject instanceof Long)) {
                resultInfo.setStatusFail();
                msg = ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636eID\u683c\u5f0f\u9519\u8bef\u3002", (String)"SalServiceImpl_2", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                resultInfo.setMessage(msg);
                resultMap.put(billEntryId, resultInfo);
                continue;
            }
            Long billId = (Long)billIdObject;
            if (!"sm_salorder".equals(billEntity) && !"sm_returnapply".equals(billEntity)) {
                resultInfo = new KitStructureResultInfo(billEntity, billId, billEntryId, baseQty);
                resultInfo.setStatusFail();
                msg = ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u9519\u8bef\u3002", (String)"SalServiceImpl_4", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                resultInfo.setMessage(msg);
                resultMap.put(billEntryId, resultInfo);
                continue;
            }
            if (baseQtyObject instanceof BigDecimal) {
                baseQty = (BigDecimal)baseQtyObject;
            }
            resultInfo = KitSalesHelper.expandKitStructure((String)billEntity, (Long)billId, (Long)billEntryId, (BigDecimal)baseQty);
            resultMap.put(billEntryId, resultInfo);
        }
        log.info("SalServiceImpl expandKitStructure end");
        return JSON.toJSONString(resultMap);
    }
}

