/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.bcm;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.mservice.Sm4BcmRptFormulaService;
import org.apache.commons.io.IOUtils;

public class Sm4BcmRptFormulaServiceImpl
implements Sm4BcmRptFormulaService {
    public String dispatchCal(String formulaName, String paramJson) throws ParseException {
        if (StringUtils.isEmpty((String)formulaName)) {
            return null;
        }
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramJson, Map.class);
        Map commParam = (Map)paramMap.get("commParam");
        List paramNameList = (List)commParam.get("formulaParamNames");
        Map paramValueMap = (Map)paramMap.get("param");
        String resultJson = "";
        if (paramValueMap != null && !paramValueMap.isEmpty() && paramNameList != null) {
            switch (formulaName) {
                case "SalOrderQty": {
                    resultJson = this.getQueryQtyJsonResult(paramNameList, paramValueMap, "sm_salorder");
                    break;
                }
                case "SalOrderAmount": {
                    resultJson = this.getQueryAmtJsonResult(paramNameList, paramValueMap, "sm_salorder");
                    break;
                }
                case "SalReturnApplyQty": {
                    resultJson = this.getQueryQtyJsonResult(paramNameList, paramValueMap, "sm_returnapply");
                    break;
                }
                case "SalReturnApplyAmount": {
                    resultJson = this.getQueryAmtJsonResult(paramNameList, paramValueMap, "sm_returnapply");
                }
            }
        }
        return resultJson;
    }

    private String getQueryAmtJsonResult(List<String> paramNameList, Map<String, List<Object>> paramValueMap, String entity) throws ParseException {
        Integer selectTypeFieldIndex = null;
        for (int i = 0; i < paramNameList.size(); ++i) {
            if (!"selecttype".equals(paramNameList.get(i))) continue;
            selectTypeFieldIndex = i;
        }
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, List<Object>> entry : paramValueMap.entrySet()) {
            String paramId = entry.getKey();
            List<Object> valueList = entry.getValue();
            if (selectTypeFieldIndex == null) continue;
            String selectType = (String)valueList.get(selectTypeFieldIndex);
            QFilter singleFilter = this.getFilter(entity, paramNameList, valueList, selectType);
            String selectField = null;
            if ("A".equalsIgnoreCase(selectType)) {
                selectField = "billentry.curamountandtax";
            } else if ("B".equalsIgnoreCase(selectType)) {
                selectField = "billentry.amountandtax";
            }
            Map<String, Object> queryResult = this.query(entity, selectField, singleFilter);
            resultMap.put(paramId, queryResult);
        }
        return SerializationUtils.toJsonString(resultMap);
    }

    private String getQueryQtyJsonResult(List<String> paramNameList, Map<String, List<Object>> paramValueMap, String entity) throws ParseException {
        Integer selectTypeFieldIndex = null;
        for (int i = 0; i < paramNameList.size(); ++i) {
            if (!"selecttype".equals(paramNameList.get(i))) continue;
            selectTypeFieldIndex = i;
        }
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, List<Object>> entry : paramValueMap.entrySet()) {
            String paramId = entry.getKey();
            List<Object> valueList = entry.getValue();
            if (selectTypeFieldIndex == null) continue;
            String selectType = (String)valueList.get(selectTypeFieldIndex);
            QFilter singleFilter = this.getFilter(entity, paramNameList, valueList, selectType);
            String selectField = null;
            if ("A".equalsIgnoreCase(selectType)) {
                selectField = "billentry.baseqty";
            } else if ("B".equalsIgnoreCase(selectType)) {
                selectField = "billentry.qty";
            }
            Map<String, Object> queryResult = this.query(entity, selectField, singleFilter);
            resultMap.put(paramId, queryResult);
        }
        return SerializationUtils.toJsonString(resultMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> query(String entity, String selectField, QFilter singleFilter) {
        HashMap<String, Object> singleMap = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)selectField)) {
            try (DataSet resultDataset = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)selectField, (QFilter[])singleFilter.toArray(), null).groupBy().sum(selectField).finish();){
                BigDecimal value = null;
                for (Row row : resultDataset) {
                    value = row.getBigDecimal(selectField);
                }
                if (value == null) return singleMap;
                singleMap.put("v", value);
                singleMap.put("type", 1);
                return singleMap;
            }
        } else {
            singleMap.put("v", BigDecimal.ZERO);
            singleMap.put("type", 1);
        }
        return singleMap;
    }

    private QFilter getFilter(String entity, List<String> paramNameList, List<Object> paramValues, String selectType) throws ParseException {
        QFilter q = new QFilter("billstatus", "=", (Object)"C");
        int size = paramValues.size();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        for (int i = 0; i < size; ++i) {
            String value = paramValues.get(i).toString();
            String number = paramNameList.get(i);
            IDataEntityProperty property = entityType.findProperty(number);
            IDataEntityProperty noEntryNumberProperty = entityType.findProperty(number.replace(entity, "").replace(".number", "").replace(".operatornumber", ""));
            QFilter qtemp = null;
            if (StringUtils.isNotEmpty((String)value)) {
                if ("begindate".equals(number)) {
                    qtemp = new QFilter("bizdate", ">=", (Object)formatter.parse(value));
                } else if ("enddate".equals(number)) {
                    Date enddate = formatter.parse(value);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(enddate);
                    calendar.add(5, 1);
                    enddate = calendar.getTime();
                    qtemp = new QFilter("bizdate", "<", (Object)enddate);
                } else if ("currency".equals(number)) {
                    qtemp = "A".equalsIgnoreCase(selectType) ? new QFilter("currency", "=", (Object)value) : new QFilter("settlecurrency", "=", (Object)value);
                } else if ("material.number".equals(number)) {
                    qtemp = new QFilter("billentry.material.masterid.number", "in", (Object)value.trim().split(","));
                } else {
                    if (property != null && property.getParent() instanceof EntryType) {
                        number = property.getParent().getName() + "." + number;
                    }
                    if (property != null || noEntryNumberProperty != null) {
                        qtemp = new QFilter(number, "in", (Object)value.trim().split(","));
                    }
                }
            }
            if (qtemp == null) continue;
            if (q == null) {
                q = qtemp;
                continue;
            }
            q.and(qtemp);
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormulaDef() throws IOException {
        String formula_catalog;
        String formula_def;
        InputStream formula_catalog_list = null;
        try (InputStream formula_def_list = null;){
            formula_def_list = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/smreportformula/sm_formula_list.json");
            formula_def = IOUtils.toString((InputStream)formula_def_list);
        }
        try {
            formula_catalog_list = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/smreportformula/sm_formula_catalog_list.json");
            formula_catalog = IOUtils.toString((InputStream)formula_catalog_list);
        }
        finally {
            if (formula_catalog_list != null) {
                formula_catalog_list.close();
            }
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)formula_def) && StringUtils.isNotEmpty((String)formula_catalog)) {
            configMap.put("formula_catalog_list", formula_catalog);
            configMap.put("formula_def_list", formula_def);
        }
        String configStr = SerializationUtils.toJsonString(configMap);
        return configStr;
    }
}

