/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.mobile;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.scmc.sm.business.helper.AmountCalcHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.enums.DiscountTypeEnum;
import kd.scmc.sm.enums.ExChangeTypeEnum;
import kd.scmc.sm.mservice.mobile.ISalService;
import kd.scmc.sm.util.CommonUtils;

public class BaseSalService
implements ISalService {
    private static final Log log = LogFactory.getLog(BaseSalService.class);

    @Override
    public DynamicObject createNewData(DynamicObject bill) {
        this.initCurrencyDefaultValue(bill);
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (billType == null) {
            bill.set("biztype", null);
        } else {
            Long biztype;
            BillEntityType entityType = (BillEntityType)bill.getDataEntityType();
            if (entityType != null && (biztype = BizTypeHelper.getDefaultBizType((String)entityType.getName(), (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam")) != null) {
                DynamicObject bd_biztype = BusinessDataServiceHelper.loadSingleFromCache((Object)biztype, (String)"bd_biztype");
                bill.set("biztype", (Object)bd_biztype);
            }
        }
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject dept = bill.getDynamicObject("dept");
        if (org != null && dept == null) {
            Long deptId = OrgHelper.getDefaultOrgRelation((String)"03", (String)"01", (Long)((Long)org.getPkValue()), (String)"toorg");
            DynamicObject deptOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)deptId, (String)"bos_org");
            bill.set("dept", (Object)deptOrg);
        }
        bill.set("bizdate", (Object)new Date());
        return bill;
    }

    @Override
    public DynamicObject propChanged(DynamicObject bill, List<Map<String, Object>> changedFields) {
        if (bill == null || changedFields == null || changedFields.size() <= 0) {
            log.error(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u503c\u6539\u53d8\u670d\u52a1\u6761\u4ef6\u4e0d\u6210\u7acb\uff0c\u76f4\u63a5\u8fd4\u56de", (String)"BaseSalService_0", (String)"scmc-sm-mservice", (Object[])new Object[0]));
            return bill;
        }
        this.doPropChangeLog(log, bill, changedFields, "before");
        block21: for (Map<String, Object> changedField : changedFields) {
            String fieldKey;
            block11 : switch (fieldKey = (String)changedField.get("field")) {
                case "customer": {
                    this.customerChanged(bill);
                    break;
                }
                case "operator": {
                    DynamicObject operator = bill.getDynamicObject("operator");
                    if (!CommonUtils.isNull((Object)operator)) {
                        bill.set("operator", (Object)operator);
                        Long operatorgrpid = operator.getLong("operatorgrpid");
                        DynamicObject group = null;
                        if (operatorgrpid != null && (long)Long.compare(operatorgrpid, 0L) != 0L) {
                            group = BusinessDataServiceHelper.loadSingleFromCache((Object)operatorgrpid, (String)"bd_operatorgroup");
                        }
                        bill.set("operatorgroup", group);
                        break;
                    }
                    bill.set("operator", null);
                    bill.set("operatorgroup", null);
                    break;
                }
                case "billentry.auxqty": {
                    DynamicObjectCollection billentry0 = bill.getDynamicObjectCollection("billentry");
                    Long entryId0 = (Long)changedField.get("entryId");
                    for (int i = 0; i < billentry0.size(); ++i) {
                        Long pkValue = (Long)((DynamicObject)billentry0.get(i)).getPkValue();
                        if (entryId0 == null || entryId0.compareTo(0L) == 0 || entryId0.compareTo(pkValue) != 0) continue;
                        BillTplHelper.calcBaseQtyAndQty((DynamicObject)bill, (int)i);
                        BillTplHelper.calculateBillAmount((DynamicObject)bill, (int)i);
                        break block11;
                    }
                    continue block21;
                }
                case "billentry.qty": {
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                    Long entryId = (Long)changedField.get("entryId");
                    for (int i = 0; i < billentry.size(); ++i) {
                        Long pkValue = (Long)((DynamicObject)billentry.get(i)).getPkValue();
                        if (entryId == null || entryId.compareTo(0L) == 0 || entryId.compareTo(pkValue) != 0) continue;
                        BillTplHelper.calcBaseQtyAndAuxQty((DynamicObject)bill, (int)i);
                        BillTplHelper.calculateBillAmount((DynamicObject)bill, (int)i);
                        break block11;
                    }
                    continue block21;
                }
                case "billentry.material": {
                    DynamicObjectCollection billentry2 = bill.getDynamicObjectCollection("billentry");
                    Long entryId2 = (Long)changedField.get("entryId");
                    for (int i = 0; i < billentry2.size(); ++i) {
                        Long pkValue = (Long)((DynamicObject)billentry2.get(i)).getPkValue();
                        if (entryId2 == null || entryId2.compareTo(0L) == 0 || entryId2.compareTo(pkValue) != 0) continue;
                        this.materialChanged(bill, i);
                        break block11;
                    }
                    continue block21;
                }
                case "billentry.price": 
                case "billentry.priceandtax": {
                    DynamicObjectCollection billentry3 = bill.getDynamicObjectCollection("billentry");
                    Long entryId3 = (Long)changedField.get("entryId");
                    for (int i = 0; i < billentry3.size(); ++i) {
                        Long pkValue = (Long)((DynamicObject)billentry3.get(i)).getPkValue();
                        if (entryId3 == null || entryId3.compareTo(0L) == 0 || entryId3.compareTo(pkValue) != 0) continue;
                        BillTplHelper.calculateBillAmount((DynamicObject)bill, (int)i);
                        break block11;
                    }
                    continue block21;
                }
                case "billentry.taxrateid": {
                    DynamicObjectCollection billentry4 = bill.getDynamicObjectCollection("billentry");
                    Long entryId4 = (Long)changedField.get("entryId");
                    for (int i = 0; i < billentry4.size(); ++i) {
                        DynamicObject entry = (DynamicObject)billentry4.get(i);
                        Long pkValue = (Long)entry.getPkValue();
                        if (entryId4 == null || entryId4.compareTo(0L) == 0 || entryId4.compareTo(pkValue) != 0) continue;
                        DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
                        if (taxRateId != null) {
                            entry.set("taxrate", taxRateId.get("taxrate"));
                        } else {
                            entry.set("taxrate", (Object)0);
                        }
                        BillTplHelper.calculateBillAmount((DynamicObject)bill, (int)i);
                        break block11;
                    }
                    continue block21;
                }
                case "warehouse": {
                    DynamicObjectCollection billentry5 = bill.getDynamicObjectCollection("billentry");
                    Long entryId5 = (Long)changedField.get("entryId");
                    for (int i = 0; i < billentry5.size(); ++i) {
                        DynamicObject entry = (DynamicObject)billentry5.get(i);
                        Long pkValue = (Long)entry.getPkValue();
                        if (entryId5 == null || entryId5.compareTo(0L) == 0 || entryId5.compareTo(pkValue) != 0) continue;
                        entry.set("location", null);
                        break block11;
                    }
                    break;
                }
            }
        }
        this.doPropChangeLog(log, bill, changedFields, "after");
        return bill;
    }

    @Override
    public DynamicObject deleteRow(DynamicObject bill, String entity, List<Long> rowIds) {
        if (bill == null || StringUtils.isEmpty((String)entity) || !"billentry".equalsIgnoreCase(entity)) {
            log.error(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u5220\u884c\u670d\u52a1\u6761\u4ef6\u4e0d\u6210\u7acb\uff0c\u76f4\u63a5\u8fd4\u56de", (String)"BaseSalService_1", (String)"scmc-sm-mservice", (Object[])new Object[0]));
            return bill;
        }
        this.doDeleteRowLog(log, bill, rowIds, "before");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entity);
        block0: for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Long pkValue = (Long)entry.getPkValue();
            if (pkValue == null || pkValue.compareTo(0L) == 0) continue;
            for (Long row : rowIds) {
                if (row == null || row.compareTo(pkValue) != 0) continue;
                AmountCalcHelper.recalHeadAmount((DynamicObject)bill, (int)i);
                entrys.remove(i);
                continue block0;
            }
        }
        this.doDeleteRowLog(log, bill, rowIds, "after");
        return bill;
    }

    @Override
    public DynamicObject addRow(DynamicObject bill, String entity, List<Long> rowIds) {
        switch (entity) {
            case "billentry": {
                DynamicObject org = bill.getDynamicObject("org");
                DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : billentry) {
                    Long rowId = (Long)entry.getPkValue();
                    if (rowId == null || rowId.compareTo(0L) == 0) continue;
                    for (Long id : rowIds) {
                        if (rowId.compareTo(id) != 0) continue;
                        entry.set("salesorg", (Object)org);
                        DynamicObject bizType = bill.getDynamicObject("biztype");
                        if (bizType == null) continue;
                        DynamicObject lineType = BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
                        entry.set("linetype", (Object)lineType);
                    }
                }
                break;
            }
        }
        return bill;
    }

    private void initCurrencyDefaultValue(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        if (org != null) {
            Long exchangeRateTableID;
            DynamicObject exRateTable;
            Long baseCurrencyID;
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
            if (map == null) {
                return;
            }
            DynamicObject currency = bill.getDynamicObject("currency");
            if (currency == null && (baseCurrencyID = (Long)map.get("baseCurrencyID")) != null) {
                currency = BusinessDataServiceHelper.loadSingleFromCache((Object)baseCurrencyID, (String)"bd_currency");
                bill.set("currency", (Object)currency);
            }
            if ((exRateTable = bill.getDynamicObject("exratetable")) == null && (exchangeRateTableID = (Long)map.get("exchangeRateTableID")) != null) {
                exRateTable = BusinessDataServiceHelper.loadSingleFromCache((Object)exchangeRateTableID, (String)"bd_exratetable");
                bill.set("exratetable", (Object)exRateTable);
            }
        }
    }

    private void materialChanged(DynamicObject bill, int index) {
        DynamicObject masterMaterial;
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        DynamicObject entry = (DynamicObject)billentry.get(index);
        DynamicObject material = entry.getDynamicObject("material");
        BigDecimal amountChange = BigDecimal.ZERO;
        entry.set("materialname", null);
        entry.set("materialmasterid", null);
        entry.set("materialversion", null);
        entry.set("unit", null);
        entry.set("baseunit", null);
        entry.set("auxunit", null);
        entry.set("ispresent", null);
        if (entry.getBigDecimal("amountandtax").compareTo(BigDecimal.ZERO) > 0) {
            amountChange = entry.getBigDecimal("amountandtax");
        }
        if (entry.getBigDecimal("amount").compareTo(BigDecimal.ZERO) > 0) {
            bill.set("totalamount", (Object)bill.getBigDecimal("totalamount").subtract(entry.getBigDecimal("amount")));
        }
        if (entry.getBigDecimal("taxamount").compareTo(BigDecimal.ZERO) > 0) {
            bill.set("totaltaxamount", (Object)bill.getBigDecimal("totaltaxamount").subtract(entry.getBigDecimal("taxamount")));
        }
        if (entry.getBigDecimal("curamountandtax").compareTo(BigDecimal.ZERO) > 0) {
            bill.set("curtotalallamount", (Object)bill.getBigDecimal("curtotalallamount").subtract(entry.getBigDecimal("curamountandtax")));
        }
        if (entry.getBigDecimal("curamount").compareTo(BigDecimal.ZERO) > 0) {
            bill.set("curtotalamount", (Object)bill.getBigDecimal("curtotalamount").subtract(entry.getBigDecimal("curamount")));
        }
        entry.set("taxamount", null);
        entry.set("amount", null);
        entry.set("amountandtax", null);
        entry.set("curtaxamount", null);
        entry.set("curamount", null);
        entry.set("curamountandtax", null);
        entry.set("qty", null);
        entry.set("baseqty", null);
        entry.set("auxqty", null);
        entry.set("price", null);
        entry.set("priceandtax", null);
        entry.set("taxrateid", null);
        entry.set("taxrate", null);
        entry.set("discounttype", (Object)DiscountTypeEnum.NULL);
        entry.set("discountrate", null);
        entry.set("discountamount", null);
        entry.set("lotnumber", null);
        if (material != null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
            entry.set("materialmasterid", (Object)masterMaterial);
            masterMaterial = entry.getDynamicObject("materialmasterid");
            entry.set("materialname", (Object)masterMaterial.getString("name"));
            if (masterMaterial.getDynamicObject("taxrate") != null) {
                DynamicObject taxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", masterMaterial.getDynamicObject("taxrate").getPkValue())});
                entry.set("taxrateid", (Object)taxrate);
                entry.set("taxrate", (Object)taxrate.getBigDecimal("taxrate"));
            } else {
                DynamicObject customer = bill.getDynamicObject("customer");
                if (customer != null && customer.getDynamicObject("taxrate") != null) {
                    DynamicObject customerTaxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", customer.getDynamicObject("taxrate").getPkValue())});
                    entry.set("taxrateid", (Object)customerTaxrate);
                    entry.set("taxrate", (Object)customerTaxrate.getBigDecimal("taxrate"));
                }
            }
            if (masterMaterial.getDynamicObject("baseunit") != null) {
                entry.set("baseunit", (Object)masterMaterial.getDynamicObject("baseunit"));
            }
            if (material.getDynamicObject("salesunit") != null) {
                entry.set("unit", (Object)material.getDynamicObject("salesunit"));
            }
            if (masterMaterial.getDynamicObject("auxptyunit") != null) {
                entry.set("auxunit", (Object)masterMaterial.getDynamicObject("auxptyunit"));
            }
        }
        entry.set("configuredcode", null);
        if (amountChange.compareTo(BigDecimal.ZERO) > 0) {
            bill.set("totalallamount", (Object)bill.getBigDecimal("totalallamount").subtract(amountChange));
        }
    }

    private void customerChanged(DynamicObject bill) {
        DynamicObject customer = bill.getDynamicObject("customer");
        if (customer == null) {
            bill.set("linkman", null);
            bill.set("address", null);
            bill.set("reccustomer", null);
            bill.set("reclinkman", null);
            bill.set("receiveaddress", null);
            bill.set("settlecustomer", null);
            bill.set("payingcustomer", null);
            bill.set("settlecurrency", null);
            bill.set("exchangerate", null);
            bill.set("settletype", null);
            bill.set("reccondition", null);
            return;
        }
        DynamicObject reccondition = customer.getDynamicObject("receivingcondid");
        if (reccondition != null) {
            bill.set("reccondition", (Object)reccondition);
        } else {
            bill.set("reccondition", null);
        }
        Long linkman = CustomerHelper.getLinkman((DynamicObject)customer);
        DynamicObject linkManObj = null;
        if (linkman != null) {
            linkManObj = BusinessDataServiceHelper.loadSingleFromCache((Object)linkman, (String)"bd_customerlinkman");
        }
        bill.set("linkman", (Object)linkManObj);
        bill.set("address", (Object)CustomerHelper.getAddress((DynamicObject)customer));
        if (customer.getDynamicObject("delivercustomerid") == null || customer.getLong("id") == customer.getDynamicObject("delivercustomerid").getLong("id")) {
            if (this.getCustomerValue(customer, "delivercustomerid") == null) {
                bill.set("reccustomer", null);
                bill.set("reclinkman", null);
                bill.set("receiveaddress", null);
            } else {
                bill.set("reccustomer", (Object)this.getCustomerValue(customer, "delivercustomerid"));
                bill.set("reclinkman", (Object)linkman);
                bill.set("receiveaddress", (Object)CustomerHelper.getAddress((DynamicObject)customer));
            }
        } else {
            DynamicObject customerValue = this.getCustomerValue(customer, "delivercustomerid");
            if (customerValue == null) {
                bill.set("reccustomer", (Object)this.getCustomerValue(customer, "delivercustomerid"));
                bill.set("reclinkman", null);
                bill.set("receiveaddress", null);
            } else {
                bill.set("reccustomer", (Object)customerValue);
                DynamicObject recCustomer = BusinessDataServiceHelper.loadSingleFromCache((Object)customerValue.getPkValue(), (String)"bd_customer");
                Long linkman1 = CustomerHelper.getLinkman((DynamicObject)recCustomer);
                DynamicObject linkManObj1 = BusinessDataServiceHelper.loadSingleFromCache((Object)linkman1, (String)"bd_customerlinkman");
                bill.set("reclinkman", (Object)linkManObj1);
                bill.set("receiveaddress", (Object)CustomerHelper.getAddress((DynamicObject)recCustomer));
            }
        }
        bill.set("payingcustomer", (Object)this.getCustomerValue(customer, "paymentcustomerid"));
        bill.set("settlecustomer", (Object)this.getCustomerValue(customer, "invoicecustomerid"));
        DynamicObject settlementType = customer.getDynamicObject("settlementtypeid");
        if (settlementType != null) {
            QFilter isenable;
            Long settlementTypeId = (Long)settlementType.getPkValue();
            QFilter id = new QFilter("id", "=", (Object)settlementTypeId);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id,", (QFilter[])new QFilter[]{id.and(isenable = new QFilter("enable", "=", (Object)"1"))});
            if (object == null) {
                this.initSettleType(bill);
            } else {
                bill.set("settletype", (Object)settlementType);
            }
        } else {
            this.initSettleType(bill);
        }
        if (customer.getDynamicObject("settlementcyid") != null) {
            bill.set("settlecurrency", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getDynamicObject("settlementcyid").getPkValue(), (String)"bd_currency", (String)"id, number, name, amtprecision,priceprecision,sign,isshowsign"));
        } else {
            bill.set("settlecurrency", (Object)bill.getDynamicObject("currency"));
        }
        this.setExChangeRate(bill);
        int size = bill.getDynamicObjectCollection("billentry").size();
        for (int i = 0; i < size; ++i) {
            BillTplHelper.calculateBillAmount((DynamicObject)bill, (int)i);
        }
    }

    private void setExChangeRate(DynamicObject bill) {
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        DynamicObject exRateTable = bill.getDynamicObject("exratetable");
        Date bizTime = bill.getDate("exratedate");
        if (currency != null && settleCurrency != null && exRateTable != null && bizTime != null) {
            bill.set("exchangerate", (Object)CurrencyHelper.getExChangeRate((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)bizTime));
            Map exRateMap = CurrencyHelper.getExchangeRateMap((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)bizTime);
            Boolean quoteType = (Boolean)exRateMap.get("quoteType");
            String exchangeType = quoteType != null && quoteType == false ? ExChangeTypeEnum.DIRECTRATE.getValue() : ExChangeTypeEnum.INDIRECTRATE.getValue();
            bill.set("exchangetype", (Object)exchangeType);
        } else {
            bill.set("exchangerate", null);
        }
    }

    private void initSettleType(DynamicObject bill) {
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isdefault.and(isenable);
        DynamicObject defaultSettlementType = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id,", (QFilter[])new QFilter[]{filter});
        if (defaultSettlementType != null) {
            bill.set("settletype", (Object)defaultSettlementType);
        } else {
            bill.set("settletype", null);
        }
    }

    private DynamicObject getCustomerValue(DynamicObject customer, String otherCustomer) {
        String bizfunction;
        if (customer == null) {
            return null;
        }
        DynamicObject dynamicObject = customer.getDynamicObject(otherCustomer);
        if (dynamicObject != null) {
            QFilter id = new QFilter("id", "=", dynamicObject.getPkValue());
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            id = id.and(status.and(enable));
            switch (otherCustomer) {
                case "invoicecustomerid": {
                    QFilter invoicehold = new QFilter("invoicehold", "=", (Object)"0");
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%2%");
                    id = id.and(invoicehold).and(bizfunction2);
                    break;
                }
                case "delivercustomerid": {
                    QFilter purchasehold = new QFilter("blockedshipment", "=", (Object)"0");
                    QFilter bizfunction1 = new QFilter("bizfunction", "like", (Object)"%1%");
                    id = id.and(purchasehold).and(bizfunction1);
                    break;
                }
                case "paymentcustomerid": {
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%3%");
                    id = id.and(bizfunction2);
                }
            }
            DynamicObject otCustomer = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (QFilter[])new QFilter[]{id});
            if (otCustomer != null) {
                return otCustomer;
            }
            if (customer.getPkValue().equals(dynamicObject.getPkValue())) {
                return null;
            }
        }
        if (StringUtils.isBlank((String)(bizfunction = customer.getString("bizfunction")))) {
            return null;
        }
        switch (otherCustomer) {
            case "invoicecustomerid": {
                if (!customer.getBoolean("invoicehold") && bizfunction.contains("2")) break;
                return null;
            }
            case "delivercustomerid": {
                if (!customer.getBoolean("blockedshipment") && bizfunction.contains("1")) break;
                return null;
            }
            case "paymentcustomerid": {
                if (bizfunction.contains("3")) break;
                return null;
            }
        }
        return customer;
    }

    public void doPropChangeLog(Log log, DynamicObject bill, List<Map<String, Object>> changedFields, String opportunity) {
        log.info(ResManager.loadKDString((String)String.format("\u79fb\u52a8\u7aef\u8c03\u7528PC\u503c\u6539\u53d8\u670d\u52a1\uff0c\u5355\u636e\u7f16\u53f7\uff1a%1$s ,\u6267\u884c\u65f6\u673a\uff1a%2$s\u3002\u5355\u5934.\u4ef7\u7a0e\u5408\u8ba1\uff1a%3$s ,\u5355\u5934.\u4ef7\u7a0e\u5408\u8ba1\u672c\u4f4d\u5e01\uff1a%4$s,\u5355\u5934.\u7a0e\u989d\uff1a%5$s ,\u5355\u5934.\u91d1\u989d\uff1a%6$s ,\u5355\u5934.\u91d1\u989d\u672c\u4f4d\u5e01\uff1a%7$s", bill.getString("billno"), opportunity, bill.getBigDecimal("totalallamount").toPlainString(), bill.getBigDecimal("curtotalallamount").toPlainString(), bill.getBigDecimal("totaltaxamount").toPlainString(), bill.getBigDecimal("totalamount").toPlainString(), bill.getBigDecimal("curtotalamount").toPlainString()), (String)"BaseSalService_2", (String)"scmc-sm-mservice", (Object[])new Object[0]));
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        block0: for (Map<String, Object> changedField : changedFields) {
            Long rowId = (Long)changedField.get("entryId");
            String fieldKey = (String)changedField.get("field");
            String logMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u503c\u6539\u53d8\u670d\u52a1\uff0c\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u6267\u884c\u65f6\u673a\uff1a%2$s\uff0c\u672c\u6b21\u8c03\u7528\u6539\u53d8\u5c5e\u6027\u4e3a\uff1a%3$s", (String)"BaseSalService_3", (String)"scmc-sm-mservice", (Object[])new Object[0]), bill.getString("billno"), opportunity, fieldKey);
            if (rowId == null || rowId == 0L) continue;
            for (int i = 0; i < billentry.size(); ++i) {
                DynamicObject entry = (DynamicObject)billentry.get(i);
                Long pkValue = (Long)entry.getPkValue();
                if (rowId.compareTo(pkValue) != 0) continue;
                log.info(logMsg + this.getEntryLogMsg(entry));
                continue block0;
            }
        }
    }

    public void doDeleteRowLog(Log log, DynamicObject bill, List<Long> rows, String opportunity) {
        log.info(ResManager.loadKDString((String)String.format("\u79fb\u52a8\u7aef\u8c03\u7528PC\u5220\u884c\u670d\u52a1\uff0c\u5355\u636e\u7f16\u53f7\uff1a%1$s ,\u6267\u884c\u65f6\u673a\uff1a%2$s\u3002\u5355\u5934.\u4ef7\u7a0e\u5408\u8ba1\uff1a%3$s ,\u5355\u5934.\u4ef7\u7a0e\u5408\u8ba1\u672c\u4f4d\u5e01\uff1a%4$s,\u5355\u5934.\u7a0e\u989d\uff1a%5$s ,\u5355\u5934.\u91d1\u989d\uff1a%6$s ,\u5355\u5934.\u91d1\u989d\u672c\u4f4d\u5e01\uff1a%7$s", bill.getString("billno"), opportunity, bill.getBigDecimal("totalallamount").toPlainString(), bill.getBigDecimal("curtotalallamount").toPlainString(), bill.getBigDecimal("totaltaxamount").toPlainString(), bill.getBigDecimal("totalamount").toPlainString(), bill.getBigDecimal("curtotalamount").toPlainString()), (String)"BaseSalService_4", (String)"scmc-sm-mservice", (Object[])new Object[0]));
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        block0: for (Long rowId : rows) {
            String logMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u5220\u884c\u670d\u52a1\uff0c\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u6267\u884c\u65f6\u673a\uff1a%2$s\uff0c\u672c\u6b21\u5220\u9664\u7684\u884cid\u4e3a%3$s", (String)"BaseSalService_5", (String)"scmc-sm-mservice", (Object[])new Object[0]), bill.getString("billno"), opportunity, rowId);
            for (int i = 0; i < billentry.size(); ++i) {
                DynamicObject entry = (DynamicObject)billentry.get(i);
                Long pkValue = (Long)entry.getPkValue();
                if (rowId.compareTo(pkValue) != 0) continue;
                log.info(logMsg + this.getEntryLogMsg(entry));
                continue block0;
            }
        }
    }

    public String getEntryLogMsg(DynamicObject entry) {
        String qty = entry.getBigDecimal("qty").toPlainString();
        String baseunit = entry.getString("baseunit.name");
        String baseqty = entry.getBigDecimal("baseqty").toPlainString();
        String unit = entry.getString("unit.name");
        String auxnuit = entry.getString("auxunit.name");
        String auxqty = entry.getBigDecimal("auxqty").toPlainString();
        String price = entry.getBigDecimal("price").toPlainString();
        String priceandtax = entry.getBigDecimal("priceandtax").toPlainString();
        String taxrate = entry.getBigDecimal("taxrate").toPlainString();
        String discounttype = entry.getString("discounttype");
        String discountrate = entry.getBigDecimal("discountrate").toPlainString();
        String amount = entry.getBigDecimal("amount").toPlainString();
        String curamount = entry.getBigDecimal("curamount").toPlainString();
        String taxamount = entry.getBigDecimal("taxamount").toPlainString();
        String curtaxamount = entry.getBigDecimal("curtaxamount").toPlainString();
        String discountamount = entry.getBigDecimal("discountamount").toPlainString();
        String amountandtax = entry.getBigDecimal("amountandtax").toPlainString();
        String curamountandtax = entry.getBigDecimal("curamountandtax").toPlainString();
        boolean ispresent = entry.getBoolean("ispresent");
        String logStr = "\uff0c";
        logStr = logStr + ResManager.loadKDString((String)"\u672c\u884c\u91cd\u70b9\u5b57\u6bb5\u5c5e\u6027\u503c\u8bb0\u5f55\u5982\u4e0b\uff1a\u6570\u91cf\uff1a%1$s\uff0c\u57fa\u672c\u5355\u4f4d\uff1a%2$s\uff0c\u57fa\u672c\u6570\u91cf\uff1a%3$s\uff0c\u8ba1\u91cf\u5355\u4f4d\uff1a%4$s\uff0c\u8f85\u52a9\u5355\u4f4d\uff1a%5$s\uff0c\u8f85\u52a9\u6570\u91cf\uff1a%6$s\uff0c\u5355\u4ef7\uff1a%7$s\uff0c\u542b\u7a0e\u5355\u4ef7\uff1a%8$s\uff0c\u7a0e\u7387\u767e\u5206\u6bd4\uff1a%9$s\uff0c\u91d1\u989d\uff1a%10$s\uff0c\u91d1\u989d\u672c\u4f4d\u5e01\uff1a%11$s\uff0c\u7a0e\u989d\uff1a%12$s\uff0c\u7a0e\u989d\u672c\u4f4d\u5e01\uff1a%13$s\uff0c\u6298\u6263\u65b9\u5f0f\uff1a%14$s\uff0c\u6298\u6263\u7387\uff1a%15$s\uff0c\u6298\u6263\u989d\uff1a%16$s\uff0c\u4ef7\u7a0e\u5408\u8ba1\uff1a%17$s\uff0c\u4ef7\u7a0e\u5408\u8ba1\u672c\u4f4d\u5e01\uff1a%18$s\uff0c\u662f\u5426\u8d60\u54c1\uff1a%19$s", (String)"BaseSalService_6", (String)"scmc-sm-mservice", (Object[])new Object[0]);
        String logMsg = String.format(logStr, qty, baseunit, baseqty, unit, auxnuit, auxqty, price, priceandtax, taxrate, amount, curamount, taxamount, curtaxamount, discounttype, discountrate, discountamount, amountandtax, curamountandtax, ispresent ? "yes" : "no");
        return logMsg;
    }
}

