/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.mobile;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.mservice.mobile.BaseSalService;
import kd.scmc.sm.util.CommonUtils;

public class DeliverNoticeService
extends BaseSalService {
    private static final Log log = LogFactory.getLog(DeliverNoticeService.class);

    @Override
    public DynamicObject propChanged(DynamicObject bill, List<Map<String, Object>> changedFields) {
        super.propChanged(bill, changedFields);
        if (bill == null || changedFields == null || changedFields.size() <= 0) {
            log.error(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u503c\u6539\u53d8\u670d\u52a1\u6761\u4ef6\u4e0d\u6210\u7acb\uff0c\u76f4\u63a5\u8fd4\u56de", (String)"DeliverNoticeService_0", (String)"scmc-sm-mservice", (Object[])new Object[0]));
            return bill;
        }
        this.doPropChangeLog(log, bill, changedFields, "before");
        for (Map<String, Object> changedField : changedFields) {
            String fieldKey;
            block5 : switch (fieldKey = (String)changedField.get("field")) {
                case "deliveroperator": {
                    DynamicObject operator = bill.getDynamicObject("deliveroperator");
                    if (!CommonUtils.isNull((Object)operator)) {
                        bill.set("deliveroperator", (Object)operator);
                        Long operatorgrpid = operator.getLong("operatorgrpid");
                        DynamicObject group = null;
                        if (operatorgrpid != null && (long)Long.compare(operatorgrpid, 0L) != 0L) {
                            group = BusinessDataServiceHelper.loadSingleFromCache((Object)operatorgrpid, (String)"bd_operatorgroup");
                        }
                        bill.set("invgroup", group);
                        break;
                    }
                    bill.set("deliveroperator", null);
                    bill.set("invgroup", null);
                    break;
                }
                case "billentry.qty": 
                case "billentry.auxqty": {
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                    Long entryId = (Long)changedField.get("entryId");
                    for (int i = 0; i < billentry.size(); ++i) {
                        Long pkValue = (Long)((DynamicObject)billentry.get(i)).getPkValue();
                        if (entryId == null || entryId.compareTo(pkValue) != 0) continue;
                        BillTplHelper.calculateDeliverUpAndDownQty((DynamicObject)bill, (int)i);
                        break block5;
                    }
                    break;
                }
            }
        }
        this.doPropChangeLog(log, bill, changedFields, "after");
        return bill;
    }

    @Override
    public DynamicObject deleteRow(DynamicObject bill, String entity, List<Long> rowIds) {
        super.deleteRow(bill, entity, rowIds);
        return bill;
    }

    @Override
    public DynamicObject addRow(DynamicObject bill, String entity, List<Long> rowIds) {
        return super.addRow(bill, entity, rowIds);
    }

    @Override
    public String getEntryLogMsg(DynamicObject entry) {
        String entryLogMsg = super.getEntryLogMsg(entry);
        String deliverqtydown = entry.getBigDecimal("deliverqtydown").toPlainString();
        String deliverbaseqtydown = entry.getBigDecimal("deliverbaseqtydown").toPlainString();
        String deliverqtyup = entry.getBigDecimal("deliverqtyup").toPlainString();
        String deliverbaseqtyup = entry.getBigDecimal("deliverbaseqtyup").toPlainString();
        String logStr = "\uff0c";
        logStr = logStr + ResManager.loadKDString((String)"\u53d1\u8d27\u4e0b\u9650\u6570\u91cf\uff1a%1$s\uff0c\u53d1\u8d27\u4e0b\u9650\u57fa\u672c\u6570\u91cf\uff1a%2$s\uff0c\u53d1\u8d27\u4e0a\u9650\u6570\u91cf\uff1a%3$s\uff0c\u53d1\u8d27\u4e0a\u9650\u57fa\u672c\u6570\u91cf\uff1a%4$s", (String)"DeliverNoticeService_1", (String)"scmc-sm-mservice", (Object[])new Object[0]);
        String logMsg = String.format(logStr, deliverqtydown, deliverbaseqtydown, deliverqtyup, deliverbaseqtyup);
        return entryLogMsg + logMsg;
    }
}

