/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.mobile;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scmc.sm.mservice.SalService4Mobile;
import kd.scmc.sm.mservice.mobile.BaseSalService;
import kd.scmc.sm.mservice.mobile.DeliverNoticeService;
import kd.scmc.sm.mservice.mobile.ISalService;
import kd.scmc.sm.mservice.mobile.ReturnApplyService;
import kd.scmc.sm.mservice.mobile.SaleOrderService;

public class SalService4MobileImpl
implements SalService4Mobile {
    private static final Log log = LogFactory.getLog(SalService4MobileImpl.class);

    public DynamicObject createNewData4Mob(DynamicObject bill) {
        if (bill == null) {
            log.error(ResManager.LoadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u65b0\u589e\u5355\u636e\u670d\u52a1\u6761\u4ef6\u4e0d\u6210\u7acb\uff0c\u76f4\u63a5\u8fd4\u56de", (String)""));
            return bill;
        }
        String billType = bill.getDataEntityType().getName();
        ISalService service = this.getService(billType);
        if (service != null) {
            return service.createNewData(bill);
        }
        return bill;
    }

    public DynamicObject propChanged4Mob(DynamicObject bill, List<Map<String, Object>> changedFields) {
        if (bill == null || changedFields == null || changedFields.size() <= 0) {
            log.error("\u79fb\u52a8\u7aef\u8c03\u7528PC\u503c\u6539\u53d8\u670d\u52a1\u6761\u4ef6\u4e0d\u6210\u7acb\uff0c\u76f4\u63a5\u8fd4\u56de");
            return bill;
        }
        String billType = bill.getDataEntityType().getName();
        ISalService service = this.getService(billType);
        if (service != null) {
            return service.propChanged(bill, changedFields);
        }
        return bill;
    }

    public DynamicObject deleteRow4Mob(DynamicObject bill, String entity, List<Long> rowIds) {
        if (bill == null || rowIds == null || rowIds.size() <= 0 || StringUtils.isEmpty((String)entity) || !"billentry".equalsIgnoreCase(entity)) {
            log.error(ResManager.LoadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u5220\u884c\u670d\u52a1\u6761\u4ef6\u4e0d\u6210\u7acb\uff0c\u76f4\u63a5\u8fd4\u56de", (String)""));
            return bill;
        }
        String billType = bill.getDataEntityType().getName();
        ISalService service = this.getService(billType);
        if (service != null) {
            return service.deleteRow(bill, entity, rowIds);
        }
        return bill;
    }

    public DynamicObject addRow4Mob(DynamicObject bill, String entity, List<Long> rowIds) {
        if (bill == null || StringUtils.isEmpty((String)entity) || rowIds == null || rowIds.size() <= 0) {
            log.error(ResManager.LoadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u589e\u884c\u670d\u52a1\u6761\u4ef6\u4e0d\u6210\u7acb\uff0c\u76f4\u63a5\u8fd4\u56de", (String)""));
            return bill;
        }
        ISalService service = this.getService(bill.getDataEntityType().getName());
        if (service != null) {
            return service.addRow(bill, entity, rowIds);
        }
        return bill;
    }

    private ISalService getService(String billType) {
        BaseSalService service = null;
        switch (billType) {
            case "sm_salorder": {
                service = new SaleOrderService();
                break;
            }
            case "sm_delivernotice": {
                service = new DeliverNoticeService();
                break;
            }
            case "sm_returnapply": {
                service = new ReturnApplyService();
            }
        }
        return service;
    }
}

