/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.mobile;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;
import kd.scmc.sm.mservice.mobile.BaseSalService;
import kd.scmc.sm.util.CommonUtils;

public class SaleOrderService
extends BaseSalService {
    private static final Log log = LogFactory.getLog(SaleOrderService.class);

    @Override
    public DynamicObject createNewData(DynamicObject bill) {
        super.createNewData(bill);
        bill.set("billcretype", (Object)"0");
        return bill;
    }

    @Override
    public DynamicObject propChanged(DynamicObject bill, List<Map<String, Object>> changedFields) {
        super.propChanged(bill, changedFields);
        if (bill == null || changedFields == null || changedFields.isEmpty()) {
            log.error(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u503c\u6539\u53d8\u670d\u52a1\u6761\u4ef6\u4e0d\u6210\u7acb\uff0c\u76f4\u63a5\u8fd4\u56de", (String)"SaleOrderService_0", (String)"scmc-sm-mservice", (Object[])new Object[0]));
            return bill;
        }
        this.doPropChangeLog(log, bill, changedFields, "before");
        for (Map<String, Object> changedField : changedFields) {
            String fieldKey;
            switch (fieldKey = (String)changedField.get("field")) {
                case "customer": {
                    SalOrderRecPlanHelper.reCalcuRecPlanAmountByContion((DynamicObject)bill);
                    break;
                }
                case "billentry.qty": 
                case "billentry.auxqty": {
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                    Long entryId = (Long)changedField.get("entryId");
                    for (int i = 0; i < billentry.size(); ++i) {
                        DynamicObject entry = (DynamicObject)billentry.get(i);
                        Long pkValue = (Long)entry.getPkValue();
                        if (entryId == null || entryId.compareTo(0L) == 0 || entryId.compareTo(pkValue) != 0) continue;
                        this.calcMinOrderBaseQty(entry);
                        BillTplHelper.calculateDeliverUpAndDownQty((DynamicObject)bill, (int)i);
                        break;
                    }
                    SalOrderRecPlanHelper.reCalcuRecPlanAmountByBill((DynamicObject)bill);
                    SalOrderRecPlanHelper.changeUnRemainAmount((DynamicObject)bill);
                    break;
                }
                case "billentry.material": {
                    DynamicObjectCollection billentry2 = bill.getDynamicObjectCollection("billentry");
                    Long entryId2 = (Long)changedField.get("entryId");
                    for (int i = 0; i < billentry2.size(); ++i) {
                        DynamicObject entry2 = (DynamicObject)billentry2.get(i);
                        Long pkValue = (Long)entry2.getPkValue();
                        if (entryId2 == null || entryId2.compareTo(0L) == 0 || entryId2.compareTo(pkValue) != 0) continue;
                        this.materialChange(bill, i);
                        break;
                    }
                    SalOrderRecPlanHelper.reCalcuRecPlanAmountByBill((DynamicObject)bill);
                    SalOrderRecPlanHelper.changeUnRemainAmount((DynamicObject)bill);
                    break;
                }
                case "billentry.price": 
                case "billentry.priceandtax": 
                case "billentry.taxrateid": {
                    SalOrderRecPlanHelper.reCalcuRecPlanAmountByBill((DynamicObject)bill);
                    SalOrderRecPlanHelper.changeUnRemainAmount((DynamicObject)bill);
                }
            }
        }
        this.doPropChangeLog(log, bill, changedFields, "after");
        return bill;
    }

    @Override
    public DynamicObject deleteRow(DynamicObject bill, String entity, List<Long> rowIds) {
        super.deleteRow(bill, entity, rowIds);
        if (bill == null || StringUtils.isEmpty((String)entity) || !"billentry".equalsIgnoreCase(entity)) {
            log.error(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u8c03\u7528PC\u5220\u884c\u670d\u52a1\u6761\u4ef6\u4e0d\u6210\u7acb\uff0c\u76f4\u63a5\u8fd4\u56de", (String)"SaleOrderService_1", (String)"scmc-sm-mservice", (Object[])new Object[0]));
            return bill;
        }
        this.doDeleteRowLog(log, bill, rowIds, "before");
        SalOrderRecPlanHelper.reCalcuRecPlanAmountByBill((DynamicObject)bill);
        SalOrderRecPlanHelper.changeUnRemainAmount((DynamicObject)bill);
        this.doDeleteRowLog(log, bill, rowIds, "after");
        return bill;
    }

    @Override
    public DynamicObject addRow(DynamicObject bill, String entity, List<Long> rowIds) {
        super.addRow(bill, entity, rowIds);
        switch (entity) {
            case "billentry": {
                DynamicObject org = bill.getDynamicObject("org");
                DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : billentry) {
                    Long rowId = (Long)entry.getPkValue();
                    if (rowId == null || rowId.compareTo(0L) == 0) continue;
                    for (Long id : rowIds) {
                        if (rowId.compareTo(id) != 0) continue;
                        if (org != null) {
                            Long settleOrgId;
                            Long stockOrgId = OrgHelper.getDefaultOrgRelation((String)"03", (String)"05", (Long)((Long)org.getPkValue()), (String)"toorg");
                            if (stockOrgId != null && Long.compare(stockOrgId, 0L) != 0) {
                                DynamicObject stockOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)stockOrgId, (String)"bos_org");
                                entry.set("e_stockorg", (Object)stockOrg);
                            }
                            if ((settleOrgId = Long.valueOf(OrgHelper.getDefaultOrgRelation((String)"03", (String)"10", (Long)((Long)org.getPkValue()), (String)"toorg"))) != null && Long.compare(settleOrgId, 0L) != 0) {
                                DynamicObject settleOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)settleOrgId, (String)"bos_org");
                                entry.set("entrysettleorg", (Object)settleOrg);
                            }
                            SaleOrderService.setOwner((Long)org.getPkValue(), entry);
                        }
                        entry.set("discounttype", (Object)"NULL");
                        entry.set("ownertype", (Object)"bos_org");
                        entry.set("deliverydate", (Object)new Date());
                        entry.set("rowclosestatus", (Object)"A");
                        entry.set("rowterminatestatus", (Object)"A");
                    }
                }
                break;
            }
        }
        return bill;
    }

    private void calcMinOrderBaseQty(DynamicObject entry) {
        BigDecimal minOrderBaseQty = BigDecimal.ZERO;
        DynamicObject masterMat = entry.getDynamicObject("material");
        if (masterMat != null) {
            BigDecimal minOrderQty = masterMat.getBigDecimal("minorderqty");
            DynamicObject salesUnit = masterMat.getDynamicObject("salesunit");
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            if (baseUnit != null && salesUnit != null && minOrderQty != null && BigDecimal.ZERO.compareTo(minOrderQty) != 0) {
                minOrderBaseQty = BillTplHelper.getDesQtyConv((DynamicObject)masterMat.getDynamicObject("masterid"), (DynamicObject)salesUnit, (BigDecimal)minOrderQty, (DynamicObject)baseUnit);
            }
        }
        entry.set("minorderbaseqty", (Object)minOrderBaseQty);
    }

    private void materialChange(DynamicObject bill, int index) {
        DynamicObjectCollection salOrderEntryDeliver;
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        DynamicObject entry = (DynamicObject)billentry.get(index);
        DynamicObject material = entry.getDynamicObject("material");
        if (material != null) {
            boolean iscontrolday = material.getBoolean("iscontrolday");
            if (iscontrolday) {
                int deliveradvanceddays = material.getInt("deliveradvdays");
                int deliverdelaydays = material.getInt("deliverdelaydays");
                entry.set("iscontrolday", (Object)Boolean.TRUE);
                entry.set("deliveradvdays", (Object)deliveradvanceddays);
                entry.set("deliverdelaydays", (Object)deliverdelaydays);
            } else {
                entry.set("iscontrolday", (Object)Boolean.FALSE);
                entry.set("deliveradvdays", (Object)0);
                entry.set("deliverdelaydays", (Object)0);
            }
        }
        if ((salOrderEntryDeliver = entry.getDynamicObjectCollection("orderdeliverentry")) != null) {
            for (DynamicObject deliverEntry : salOrderEntryDeliver) {
                deliverEntry.set("d_planunit", (Object)entry.getDynamicObject("unit"));
            }
        }
        entry.set("deliverqtydown", null);
        entry.set("deliverqtyup", null);
        entry.set("deliverbaseqtydown", null);
        entry.set("deliverbaseqtyup", null);
        if (material != null) {
            boolean isControlQty = material.getBoolean("iscontrolqty");
            entry.set("iscontrolqty", (Object)isControlQty);
            if (isControlQty) {
                BigDecimal delieveRateUp = material.getBigDecimal("dlivrateceiling");
                BigDecimal delieveRateDown = material.getBigDecimal("dlivratefloor");
                entry.set("deliverrateup", (Object)delieveRateUp);
                entry.set("deliverratedown", (Object)delieveRateDown);
                BillTplHelper.calculateDeliverUpAndDownQty((DynamicObject)bill, (int)index);
            }
        }
        entry.set("minorderbaseqty", (Object)BigDecimal.ZERO);
    }

    public static void setOwner(Long orgId, DynamicObject entry) {
        DynamicObject stockOrg = entry.getDynamicObject("e_stockorg");
        if (stockOrg != null) {
            Long ownerId = SaleOrderService.getOwnerDefaultValue(orgId, (Long)stockOrg.getPkValue());
            if (ownerId != 0L) {
                DynamicObject owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org");
                entry.set("owner", (Object)owner);
            } else {
                entry.set("owner", null);
            }
        }
    }

    public static Long getOwnerDefaultValue(Long OrgId, Long stockOrgId) {
        List orgIds;
        Long accountingOrg = SaleOrderService.getAcccountOrg4Org(OrgId);
        Map<String, Object> allToOrg = SaleOrderService.getOrgRelationMap(stockOrgId, "10", "05", "fromorg");
        if (allToOrg != null && !allToOrg.isEmpty() && (orgIds = (List)allToOrg.get("orgId")).contains(accountingOrg)) {
            return accountingOrg;
        }
        return SaleOrderService.getOwnerDefaultValue(stockOrgId);
    }

    public static Long getAcccountOrg4Org(Long OrgId) {
        if (OrgId == null) {
            return 0L;
        }
        Long acccountOrgPK = 0L;
        Map orgMap = OrgHelper.getCompanyByOrg((Long)OrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (!CommonUtils.isNull((Object)orgMap)) {
            acccountOrgPK = (Long)orgMap.get("id");
        }
        return acccountOrgPK;
    }

    public static Long getOwnerDefaultValue(Long stockOrgId) {
        if (stockOrgId == null) {
            return 0L;
        }
        return SaleOrderService.getOrgRelationDefaultValue(stockOrgId, "10", "05", "fromorg");
    }

    public static Long getOrgRelationDefaultValue(Long org, String fromViewType, String toViewType, String directViewType) {
        Map<String, Object> allToOrg = SaleOrderService.getOrgRelationMap(org, fromViewType, toViewType, directViewType);
        List detailList = (List)allToOrg.get("data");
        for (Map detailMap : detailList) {
            Boolean isDefault = (Boolean)detailMap.get("isDefault");
            if (!isDefault.booleanValue()) continue;
            return (Long)detailMap.get("orgId");
        }
        return 0L;
    }

    public static Map<String, Object> getOrgRelationMap(Long org, String fromViewType, String toViewType, String directViewType) {
        OrgRelationParam param = SaleOrderService.getOrgRelationParam(org, fromViewType, toViewType, directViewType);
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
    }

    public static OrgRelationParam getOrgRelationParam(Long org, String fromViewType, String toViewType, String directViewType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(org.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        if ("fromorg".equals(directViewType)) {
            param.setDirectViewType("fromorg");
        } else if ("toorg".equals(directViewType)) {
            param.setDirectViewType("toorg");
        }
        return param;
    }

    @Override
    public String getEntryLogMsg(DynamicObject entry) {
        String entryLogMsg = super.getEntryLogMsg(entry);
        String deliverqtydown = entry.getBigDecimal("deliverqtydown").toPlainString();
        String deliverbaseqtydown = entry.getBigDecimal("deliverbaseqtydown").toPlainString();
        String deliverqtyup = entry.getBigDecimal("deliverqtyup").toPlainString();
        String deliverbaseqtyup = entry.getBigDecimal("deliverbaseqtyup").toPlainString();
        String logStr = "\uff0c";
        logStr = logStr + ResManager.loadKDString((String)"\u53d1\u8d27\u4e0b\u9650\u6570\u91cf\uff1a%1$s\uff0c\u53d1\u8d27\u4e0b\u9650\u57fa\u672c\u6570\u91cf\uff1a%2$s\uff0c\u53d1\u8d27\u4e0a\u9650\u6570\u91cf\uff1a%3$s\uff0c\u53d1\u8d27\u4e0a\u9650\u57fa\u672c\u6570\u91cf\uff1a%4$s", (String)"SaleOrderService_2", (String)"scmc-sm-mservice", (Object[])new Object[0]);
        String logMsg = String.format(logStr, deliverqtydown, deliverbaseqtydown, deliverqtyup, deliverbaseqtyup);
        return entryLogMsg + logMsg;
    }
}

