/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;
import kd.scmc.plat.business.service.upgrade.BillTplUpgradeImpl;

public class SalBillAmountUpgradeServiceImpl
implements IUpgradeService {
    private static Log log = LogFactory.getLog(BillTplUpgradeImpl.class);
    private static final int BATCH_SIZE = 2000;
    private static final String deliverNoticeTable = "t_sm_delivernotice";
    private static final String deliverNoticeEntryTable = "t_sm_delivernoticeentry";
    private static final String returnApplyTable = "t_sm_returnapply";
    private static final String returnApplyEntryTable = "t_sm_returnapplyentry";
    private Map AmountMap = new HashMap(16){
        {
            this.put("ftotaltaxamount", "ftaxamount");
            this.put("ftotalamount", "famount");
            this.put("ftotalallamount", "famountandtax");
            this.put("fcurtotalamount", "fcuramount");
            this.put("fcurtotalallamount", "fcuramountandtax");
        }
    };

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute dbRoute = new DBRoute("scm");
        ThreadPools.executeOnce((String)this.getClass().getName(), () -> {
            this.doUpdate(dbRoute, deliverNoticeTable, deliverNoticeEntryTable, result);
            this.doUpdate(dbRoute, returnApplyTable, returnApplyEntryTable, result);
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(DBRoute dbRoute, String headTable, String entryTable, UpgradeResult result) {
        for (Map.Entry<String, String> entry : this.AmountMap.entrySet()) {
            block34: {
                StringBuilder sql_query = new StringBuilder(" SELECT ").append("FID,").append((String)entry.getValue()).append(" FROM ").append(entryTable).append(" WHERE ").append((String)entry.getValue()).append(" != 0");
                StringBuilder sql_update = new StringBuilder(" UPDATE ").append(headTable).append(" ").append(" SET ").append((String)entry.getKey()).append(" = ").append(" ? ").append(" WHERE FID = ? ").append(" AND ").append((String)entry.getKey()).append(" =0 ");
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                try (DataSet ds = null;){
                    Object row22;
                    ds = this.queryDataSet(dbRoute, sql_query.toString(), entry);
                    for (Object row22 : ds) {
                        Object[] params = new Object[]{row22.get(entry.getValue()), row22.get("FID")};
                        paramList.add(params);
                        if (paramList.size() <= 2000) continue;
                        TXHandle h = TX.required((String)this.getClass().getName());
                        Throwable throwable = null;
                        try {
                            try {
                                this.executeBatch(dbRoute, sql_update.toString(), paramList);
                                paramList.clear();
                            }
                            catch (Throwable e) {
                                h.markRollback();
                                result.setSuccess(false);
                                String err = "Amount field upgrade failed! table name: " + headTable + " field name : " + entry.getKey() + e;
                                result.setErrorInfo(err);
                                result.setLog(err);
                                log.info(err);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (h == null) continue;
                            if (throwable != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            h.close();
                        }
                    }
                    if (paramList.isEmpty()) break block34;
                    TXHandle h = TX.required((String)this.getClass().getName());
                    row22 = null;
                    try {
                        try {
                            this.executeBatch(dbRoute, sql_update.toString(), paramList);
                        }
                        catch (Throwable e) {
                            h.markRollback();
                            result.setSuccess(false);
                            String err = "Amount field upgrade failed! table name: " + headTable + " field name : " + entry.getKey() + e;
                            result.setErrorInfo(err);
                            result.setLog(err);
                            log.info(err);
                        }
                    }
                    catch (Throwable throwable) {
                        row22 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (h != null) {
                            if (row22 != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)row22).addSuppressed(throwable);
                                }
                            } else {
                                h.close();
                            }
                        }
                    }
                }
            }
            result.setSuccess(true);
            result.setLog("Amount field upgrade success!");
        }
    }

    private void executeBatch(DBRoute dbRoute, String sql_update, List<Object[]> paramList) {
        DB.executeBatch((DBRoute)dbRoute, (String)sql_update, paramList);
    }

    private DataSet queryDataSet(DBRoute dbRoute, String sql_query, Map.Entry<String, String> entry) {
        return DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)sql_query, null).groupBy(new String[]{"FID"}).sum(entry.getValue()).finish();
    }
}

