/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;

public class SalOrderRowNumUpgrade
implements IUpgradeService {
    private static final int BATCH_COUNT = 5000;
    private Log logger = LogFactory.getLog(SalOrderRowNumUpgrade.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ThreadPools.executeOnce((String)"SalOrderRowNumUpgrade", () -> this.updateSalOrderRowNum());
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        return result;
    }

    public void updateSalOrderRowNum() {
        this.logger.info("start upgrade t_sm_salorderentry_r fconbillrownum.");
        String xSmSql = "SELECT fsrcbillentryid FROM t_sm_salorderentry_r WHERE fsrcbillentity='conm_salcontract' AND (fconbillrownum=' ' OR (fconbillrownum IS NULL))";
        DataSet xSm = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)xSmSql);
        HashSet<Long> srcBillEntryIds = new HashSet<Long>();
        try (DataSet invDataSetCopy = xSm.copy();){
            for (Row row : invDataSetCopy) {
                Long fsrcbillentryid = row.getLong("fsrcbillentryid");
                srcBillEntryIds.add(fsrcbillentryid);
            }
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fseq,frownum,fentryid from t_conm_salcontractentry where ", new Object[0]);
        sqlBuilder.appendIn("fentryid", srcBillEntryIds.toArray());
        DataSet xConm = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (SqlBuilder)sqlBuilder);
        this.logger.info("\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4e2d\u6765\u6e90\u5355\u636e\u884cID\u5bf9\u5e94\u7684\u9500\u552e\u5408\u540c\u96c6\u5408:" + xConm);
        DataSet xRes = xSm.leftJoin(xConm).on("fsrcbillentryid", "fentryid").select(new String[]{"fentryid", "fseq"}).finish().where("fentryid <> null");
        this.logger.info("\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4e0e\u9500\u552e\u5408\u540c\u8fde\u63a5\u540e\u7684\u5206\u5f55id\u548c\u5e8f\u53f7:" + xRes);
        String sql = "update t_sm_salorderentry_r set fconbillrownum = ? where fsrcbillentryid = ?";
        ArrayList<Object[]> param = new ArrayList<Object[]>(5000);
        int rowCount = 0;
        for (Row row : xRes) {
            Long entryid = row.getLong("fentryid");
            Long fseq = row.getLong("fseq");
            if (entryid == null || entryid == 0L || fseq == null || fseq == 0L) continue;
            param.add(new Object[]{String.valueOf(fseq), entryid});
            if (++rowCount % 5000 != 0) continue;
            this.doUpdate(sql, param);
            param.clear();
        }
        if (!param.isEmpty()) {
            this.doUpdate(sql, param);
            this.logger.info("end upgrade t_sm_salorderentry_r fconbillrownum. The upgrade " + rowCount);
        }
        param.clear();
        xRes.close();
        xSm.close();
    }

    private void doUpdate(String sql, List<Object[]> param) {
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, param);
                this.logger.info("execute upgrade fconbillrownum. The param size is " + param.size());
            }
            catch (Exception e) {
                h.markRollback();
                String err = "database execution failed,errorInfo" + e.getMessage();
                this.logger.info(err);
            }
        }
    }
}

