/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.upgrade.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterWriter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class BillTypeParameterUpgradeService
implements IUpgradeService {
    private static Log log = LogFactory.getLog(BillTypeParameterUpgradeService.class);
    private static final String BIZTYPE = "biztype";
    private static final String BIZTYPEENTRY = "entryentity";
    private static final String ENTRY_BIZTYPENUMBER = "biztypenumber";
    private static final String ENTRY_ISDEFAULT = "isdefault";
    private static final String ENTRY_ISPRESET = "ispreset";

    public UpgradeResult doUpdate(UpgradeResult result, String appId, String billTypeParamNo, Map<Long, Long[]> preinsdata) {
        List<String> formIds = BillTypeParameterUpgradeService.getBillFormIDByAppId(appId);
        QFilter q = new QFilter("billformid", "in", formIds);
        try {
            DynamicObject[] loads;
            for (DynamicObject dyn : loads = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"id,billformid,number", (QFilter[])new QFilter[]{q})) {
                DynamicObject[] bizTypes;
                DynamicObjectCollection entrys;
                Long bizTypeId;
                if (dyn == null || !(dyn.get("billformid") instanceof DynamicObject)) continue;
                Long billTypeId = (Long)dyn.getPkValue();
                String formId = (String)dyn.getDynamicObject("billformid").getPkValue();
                ArrayList preBizTypes = preinsdata != null && preinsdata.get(billTypeId) != null ? Arrays.asList((Object[])preinsdata.get(billTypeId)) : new ArrayList(16);
                Long defaultBizTypeId = preBizTypes != null && preBizTypes.size() > 0 ? (Long)preBizTypes.get(0) : null;
                ArrayList bizTypeEntrys = new ArrayList(16);
                bizTypeEntrys.addAll(preBizTypes);
                Object value = SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)billTypeParamNo, (long)billTypeId);
                if (!(value instanceof DynamicObject)) continue;
                DynamicObject billTypeParam = (DynamicObject)value;
                Long l = bizTypeId = billTypeParam.get(BIZTYPE) instanceof DynamicObject ? (Long)billTypeParam.getDynamicObject(BIZTYPE).getPkValue() : null;
                if (bizTypeId != null) {
                    if (!bizTypeEntrys.contains(bizTypeId)) {
                        bizTypeEntrys.add(bizTypeId);
                    }
                    defaultBizTypeId = bizTypeId;
                }
                if ((entrys = billTypeParam.getDynamicObjectCollection(BIZTYPEENTRY)) == null || entrys.size() != 0) continue;
                for (DynamicObject bizType : bizTypes = BusinessDataServiceHelper.load((Object[])bizTypeEntrys.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bd_biztype").getDynamicObjectType())) {
                    if (bizType == null || bizType.getPkValue() == null) continue;
                    Long bizTypeEntry = (Long)bizType.getPkValue();
                    DynamicObject createInstance = (DynamicObject)entrys.getDynamicObjectType().createInstance();
                    createInstance.set(ENTRY_BIZTYPENUMBER, (Object)bizType);
                    if (bizTypeEntry.equals(defaultBizTypeId)) {
                        createInstance.set(ENTRY_ISDEFAULT, (Object)Boolean.TRUE);
                    }
                    if (preBizTypes.contains(bizTypeEntry)) {
                        createInstance.set(ENTRY_ISPRESET, (Object)Boolean.TRUE);
                    }
                    entrys.add((Object)createInstance);
                }
                String jsonData = this.serializeToJsonData(billTypeParam);
                ParameterWriter.saveBillTypeParameter((String)formId, (long)billTypeId, (String)jsonData);
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            String message = "database execution failed,errorInfo" + e.getMessage();
            result.setErrorInfo(message);
            result.setLog(message);
            log.error(message);
        }
        return result;
    }

    private static List<String> getBillFormIDByAppId(String appId) {
        HashSet<String> entityIDSet = new HashSet<String>();
        String modeltype = "BillFormModel";
        DynamicObject[] entitys = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("bizappid", "=", (Object)appId), new QFilter("modeltype", "=", (Object)modeltype)});
        if (entitys != null && entitys.length > 0) {
            for (DynamicObject entity : entitys) {
                String number = entity.getString("number");
                if (!StringUtils.isNotEmpty((CharSequence)number)) continue;
                entityIDSet.add(entity.getString("number"));
            }
        }
        return new ArrayList<String>(entityIDSet);
    }

    private String serializeToJsonData(DynamicObject param) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(param.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return jser.serializeToString((Object)param, null);
    }
}

