/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.wbso;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.helper.LockHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.mservice.wbso.pojo.WbSoParam;
import kd.scmc.sm.util.CommonUtils;

public abstract class WbSoService {
    protected static final TrackLogService trackLog = new TrackLogService(WbSoService.class, "sm");
    protected String wbBillType;

    protected abstract String getSelectFields();

    protected abstract List<String> checkParam(List<WbSoParam> var1);

    protected abstract DynamicObject[] genWbBill(Map<Long, List<WbSoParam>> var1, DynamicObject[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> doWbExecute(List<Map<String, Object>> param) throws Exception {
        trackLog.startInfo(String.valueOf(param));
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        Boolean isAllSuccess = Boolean.TRUE;
        List<Object> errorMsgList = new ArrayList(8);
        try {
            List<WbSoParam> wbSoParamList = WbSoParam.transForm2EntityList(param);
            ArrayList<Map<String, Object>> beforeBillInfo = new ArrayList<Map<String, Object>>(8);
            ArrayList<Map<String, Object>> afterBillInfo = new ArrayList<Map<String, Object>>(8);
            errorMsgList = this.checkParam(wbSoParamList);
            if (errorMsgList != null && errorMsgList.size() > 0) {
                isAllSuccess = Boolean.FALSE;
                trackLog.error("errorMsgList:" + errorMsgList);
            }
            if (wbSoParamList.size() > 0) {
                Map<Long, List<WbSoParam>> paramMap = this.getEntityMap(wbSoParamList, "ENTRY");
                Set<Long> idSet = this.getBillIdSet(wbSoParamList);
                List partition = CommonUtils.partition(new ArrayList<Long>(idSet), (int)100);
                if (partition != null && partition.size() > 0) {
                    for (List idList : partition) {
                        List lockList = LockHelper.createDLocks(this.getLockKeys(idList), (boolean)true);
                        try {
                            LockHelper.tryDLocks((List)lockList, (Long)60000L);
                            DynamicObject[] beforeBills = this.getSrcBill(idList);
                            beforeBillInfo.addAll(this.getBillLogInfo(beforeBills));
                            DynamicObject[] afterBills = this.genWbBill(paramMap, beforeBills);
                            afterBillInfo.addAll(this.getBillLogInfo(afterBills));
                            if (afterBills == null || afterBills.length <= 0) continue;
                            SaveServiceHelper.update((DynamicObject[])afterBills);
                        }
                        finally {
                            this.releaseLock(lockList);
                        }
                    }
                }
            }
            returnMap.put("isAllSuccess", isAllSuccess);
            returnMap.put("errorMsg", errorMsgList);
            trackLog.endInfo("wbso result:" + String.valueOf(returnMap) + "\nbeforeBills: " + beforeBillInfo + "\nafterBills: " + afterBillInfo);
            return returnMap;
        }
        catch (Exception e) {
            String stackTrace = Arrays.toString(e.getStackTrace());
            trackLog.error(e.getMessage() + stackTrace);
            throw new Exception(e);
        }
    }

    private List<Map<String, Object>> getBillLogInfo(DynamicObject[] bills) {
        if (bills == null) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(bills.length);
        for (DynamicObject bill : bills) {
            HashMap<String, Object> propMap = new HashMap<String, Object>(8);
            propMap.put("id", bill.getPkValue());
            propMap.put("billno", bill.getString("billno"));
            DataEntityPropertyCollection propCol = bill.getDataEntityType().getProperties();
            for (IDataEntityProperty prop : propCol) {
                if (prop instanceof AmountProp || prop instanceof QtyProp) {
                    propMap.put(prop.getName(), bill.getBigDecimal(prop.getName()));
                }
                if (!(prop instanceof EntryProp)) continue;
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(prop.getName());
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    DataEntityPropertyCollection entryPropCol = entry.getDataEntityType().getProperties();
                    for (IDataEntityProperty entryProp : entryPropCol) {
                        if (!(entryProp instanceof AmountProp) && !(entryProp instanceof QtyProp)) continue;
                        propMap.put(entryProp.getName() + (i + 1), entry.getBigDecimal(entryProp.getName()));
                    }
                }
            }
            list.add(propMap);
        }
        return list;
    }

    private Set<Long> getBillIdSet(List<WbSoParam> wbSoParamList) {
        HashSet<Long> ids = new HashSet<Long>(8);
        for (WbSoParam param : wbSoParamList) {
            if (this.wbBillType != null) {
                if ("AR".equals(this.wbBillType) || "CFM".equals(this.wbBillType)) {
                    ids.add(param.getArMainBillID());
                }
                if (!"REC".equals(this.wbBillType)) continue;
                ids.add(param.getRecMainBillID());
                continue;
            }
            if ("recpaysettle".equals(param.getSettleRelation()) || "recclearing".equals(param.getSettleRelation()) || StringUtils.isEmpty((CharSequence)param.getSettleRelation())) {
                ids.add(param.getRecMainBillID());
                continue;
            }
            ids.add(param.getArMainBillID());
        }
        return ids;
    }

    private Set<String> getLockKeys(List<Long> keyList) {
        HashSet<String> set = new HashSet<String>(8);
        if (CommonUtils.isNull(keyList)) {
            return set;
        }
        for (Long id : keyList) {
            set.add("WbSoService_" + id);
        }
        return set;
    }

    private void releaseLock(List<DLock> dlockList) {
        if (dlockList == null) {
            return;
        }
        for (DLock dLock : dlockList) {
            dLock.unlock();
        }
    }

    public Map<Long, List<WbSoParam>> getEntityMap(List<WbSoParam> wbSoParamList, String position) {
        HashMap<Long, List<WbSoParam>> map = new HashMap<Long, List<WbSoParam>>(wbSoParamList.size());
        Long id = 0L;
        for (WbSoParam param : wbSoParamList) {
            if (this.wbBillType != null) {
                if ("AR".equals(this.wbBillType) || "CFM".equals(this.wbBillType)) {
                    if ("HEAD".equals(position)) {
                        id = param.getArMainBillID();
                    }
                    if ("ENTRY".equals(position)) {
                        id = param.getArMainBillEntryID();
                    }
                }
                if ("REC".equals(this.wbBillType)) {
                    if ("HEAD".equals(position)) {
                        id = param.getRecMainBillID();
                    }
                    if ("ENTRY".equals(position)) {
                        id = param.getRecMainBillEntryID();
                    }
                }
            } else if ("recpaysettle".equals(param.getSettleRelation()) || "recclearing".equals(param.getSettleRelation()) || StringUtils.isEmpty((CharSequence)param.getSettleRelation())) {
                if ("HEAD".equals(position)) {
                    id = param.getRecMainBillID();
                }
                if ("ENTRY".equals(position)) {
                    id = param.getRecMainBillEntryID();
                }
            } else {
                if ("HEAD".equals(position)) {
                    id = param.getArMainBillID();
                }
                if ("ENTRY".equals(position)) {
                    id = param.getArMainBillEntryID();
                }
            }
            if (map.get(id) == null) {
                ArrayList<WbSoParam> list = new ArrayList<WbSoParam>(8);
                list.add(param);
                map.put(id, list);
                continue;
            }
            ((List)map.get(id)).add(param);
        }
        return map;
    }

    private DynamicObject[] getSrcBill(List<Long> mainBillId) {
        if (mainBillId == null || StringUtils.isEmpty((CharSequence)this.getSelectFields())) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "in", mainBillId);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sm_salorder", (String)this.getSelectFields(), (QFilter[])new QFilter[]{idFilter}, null);
        return bills;
    }

    protected List<String> defaultParamCheck(List<WbSoParam> params) {
        ArrayList<String> errorList = new ArrayList<String>(8);
        if (params == null) {
            errorList.add(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"WbSoService_12", (String)"scmc-sm-mservice", (Object[])new Object[0]));
            return errorList;
        }
        Iterator<WbSoParam> iterator = params.iterator();
        while (iterator.hasNext()) {
            String errorMsg;
            Boolean isError = Boolean.FALSE;
            WbSoParam param = iterator.next();
            Long soid = null;
            String mainBillEntity = null;
            if (this.wbBillType != null) {
                if ("AR".equals(this.wbBillType) || "CFM".equals(this.wbBillType)) {
                    soid = param.getArMainBillID();
                    mainBillEntity = param.getArMainBillEntity();
                }
                if ("REC".equals(this.wbBillType)) {
                    soid = param.getRecMainBillID();
                    mainBillEntity = param.getRecMainBillEntity();
                }
            } else if ("recpaysettle".equals(param.getSettleRelation()) || "recclearing".equals(param.getSettleRelation()) || StringUtils.isEmpty((CharSequence)param.getSettleRelation())) {
                soid = param.getRecMainBillID();
                mainBillEntity = param.getRecMainBillEntity();
            } else {
                soid = param.getArMainBillID();
                mainBillEntity = param.getArMainBillEntity();
            }
            if (soid == null) {
                errorList.add(ResManager.loadKDString((String)"\u5b58\u5728\u6838\u5fc3\u5355\u636eID\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"WbSoService_13", (String)"scmc-sm-mservice", (Object[])new Object[0]));
                isError = Boolean.TRUE;
            }
            String soidStr = ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636eID:", (String)"WbSoService_14", (String)"scmc-sm-mservice", (Object[])new Object[0]);
            if (!"sm_salorder".equals(mainBillEntity)) {
                errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u9700\u4e3a\u201c\u9500\u552e\u8ba2\u5355\u201d\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"WbSoService_15", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                errorList.add(soidStr + soid + " " + errorMsg);
                isError = Boolean.TRUE;
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getSettleRelation()) && param.getInternalAsst() == null) {
                errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u5185\u90e8\u5ba2\u5546\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"WbSoService_16", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                errorList.add(soidStr + soid + " " + errorMsg);
                isError = Boolean.TRUE;
            }
            if (!isError.booleanValue()) continue;
            iterator.remove();
        }
        return errorList;
    }

    protected Map<String, Object> CalcArWbData(List<WbSoParam> paramMapList, DynamicObject entrysettleorg, BigDecimal BaseQty, BigDecimal Amount) {
        HashMap<String, Object> wbData = new HashMap<String, Object>(8);
        boolean isNeedWB = false;
        for (WbSoParam param : paramMapList) {
            Long arsettleorgid = param.getSettleOrgID();
            BigDecimal wbbaseqty = param.getWbBaseQty();
            BigDecimal wbamount = param.getWbAmount();
            if (!entrysettleorg.getPkValue().equals(arsettleorgid)) continue;
            if (wbbaseqty != null && BigDecimalUtil.isNotZero((BigDecimal)wbbaseqty) || wbamount != null && BigDecimalUtil.isNotZero((BigDecimal)wbamount)) {
                isNeedWB = true;
            }
            if (wbbaseqty != null) {
                BaseQty = BaseQty.add(wbbaseqty);
            }
            if (wbamount == null) continue;
            Amount = Amount.add(wbamount);
        }
        wbData.put("isNeedWB", isNeedWB);
        wbData.put("wbQty", BaseQty);
        wbData.put("wbAmount", Amount);
        return wbData;
    }

    protected DynamicObject[] genWbRecHeadBill(Map<Long, List<WbSoParam>> paramMap, DynamicObject[] beforeBills, boolean isPreRec) {
        if (beforeBills == null || paramMap == null) {
            return null;
        }
        for (DynamicObject bill : beforeBills) {
            BigDecimal totalallamount = bill.getBigDecimal("totalallamount");
            BigDecimal preRecAmount = BigDecimal.ZERO;
            if (isPreRec) {
                preRecAmount = bill.getBigDecimal("prereceiptamount");
            }
            BigDecimal recAmount = bill.getBigDecimal("receiptamount");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                List<WbSoParam> paramList = paramMap.get(entry.getPkValue());
                DynamicObject entrysettleorg = entry.getDynamicObject("entrysettleorg");
                if (paramList == null) continue;
                for (WbSoParam param : paramList) {
                    Boolean isOrgSame = entrysettleorg != null && entrysettleorg.getPkValue().equals(param.getSettleOrgID());
                    if (!isOrgSame.booleanValue()) continue;
                    if (isPreRec) {
                        preRecAmount = preRecAmount.add(param.getWbAmount());
                    }
                    recAmount = recAmount.add(param.getWbAmount());
                }
            }
            String field = ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"WbSoService_7", (String)"scmc-sm-mservice", (Object[])new Object[0]);
            if (isPreRec) {
                bill.set("prereceiptamount", (Object)preRecAmount);
                String field1 = ResManager.loadKDString((String)"\u5df2\u9884\u6536\u91d1\u989d", (String)"WbSoService_10", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                this.setWarnLog(bill.getString("billno"), null, field1, preRecAmount, field, totalallamount);
            }
            bill.set("receiptamount", (Object)recAmount);
            String field2 = ResManager.loadKDString((String)"\u5df2\u6536\u91d1\u989d", (String)"WbSoService_11", (String)"scmc-sm-mservice", (Object[])new Object[0]);
            this.setWarnLog(bill.getString("billno"), null, field2, recAmount, field, totalallamount);
        }
        return beforeBills;
    }

    protected boolean isNull(Long id) {
        return id == null || id.equals(0L);
    }

    protected void setWarnLog(String billNo, String seq, String field1, BigDecimal bigDecimal1, String field2, BigDecimal bigDecimal2) {
        if (bigDecimal1 == null || bigDecimal2 == null) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)seq)) {
            String notice;
            if (bigDecimal1.compareTo(BigDecimal.ZERO) < 0) {
                notice = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 %1$s\uff1a\u7b2c%2$s\u884c\uff0c%3$s %4$s \u5c0f\u4e8e\u96f6\uff0c\u8bf7\u6ce8\u610f\uff01", (String)"WbSoService_0", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                trackLog.warn(String.format(notice, billNo, seq, field1, bigDecimal1.toString()));
            }
            if (bigDecimal1.compareTo(bigDecimal2) > 0) {
                notice = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 %1$s\uff1a\u7b2c%2$s\u884c\uff0c%3$s %4$s\u5927\u4e8e%5$s %6$s\uff0c\u8bf7\u6ce8\u610f\uff01", (String)"WbSoService_1", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                trackLog.warn(String.format(notice, billNo, seq, field1, bigDecimal1.toString(), field2, bigDecimal2.toString()));
            }
        } else {
            String notice;
            if (bigDecimal1.compareTo(BigDecimal.ZERO) < 0) {
                notice = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 %1$s\uff1a%2$s %3$s \u5c0f\u4e8e\u96f6\uff0c\u8bf7\u6ce8\u610f\uff01", (String)"WbSoService_2", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                trackLog.warn(String.format(notice, billNo, field1, bigDecimal1.toString()));
            }
            if (bigDecimal1.compareTo(bigDecimal2) > 0) {
                notice = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 %1$s\uff1a%2$s %3$s\u5927\u4e8e%4$s %5$s\uff0c\u8bf7\u6ce8\u610f\uff01", (String)"WbSoService_3", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                trackLog.warn(String.format(notice, billNo, field1, bigDecimal1.toString(), field2, bigDecimal2.toString()));
            }
        }
    }
}

