/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.wbso.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.scmc.sm.mservice.wbso.WbSoService;
import kd.scmc.sm.mservice.wbso.pojo.WbSoParam;

public class WbSOAr
extends WbSoService {
    public WbSOAr() {
        this.wbBillType = "AR";
    }

    @Override
    protected String getSelectFields() {
        List<String> selectors = Arrays.asList("id", "billno", "billentry.id ", "billentry.seq", "billentry.material", "billentry.unit", "billentry.unit.precisionaccount", "billentry.unit.precision", "billentry.baseunit", "billentry.entrysettleorg", "billentry.qty", "billentry.amountandtax", "billentry.joinpriceqty", "billentry.basearqty", "billentry.aramount");
        return String.join((CharSequence)",", selectors);
    }

    @Override
    protected List<String> checkParam(List<WbSoParam> params) {
        return this.defaultParamCheck(params);
    }

    @Override
    protected DynamicObject[] genWbBill(Map<Long, List<WbSoParam>> entryMap, DynamicObject[] beforeBills) {
        if (beforeBills == null || entryMap == null) {
            return null;
        }
        for (DynamicObject bill : beforeBills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                Map<String, Object> wbData;
                List<WbSoParam> paramMapList = entryMap.get(entry.getPkValue());
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null) continue;
                DynamicObject unit = entry.getDynamicObject("unit");
                DynamicObject baseunit = entry.getDynamicObject("baseunit");
                DynamicObject entrysettleorg = entry.getDynamicObject("entrysettleorg");
                BigDecimal arBaseQty = entry.getBigDecimal("basearqty");
                BigDecimal arAmount = entry.getBigDecimal("aramount");
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal amountandtax = entry.getBigDecimal("amountandtax");
                if (paramMapList == null || (wbData = this.CalcArWbData(paramMapList, entrysettleorg, arBaseQty, arAmount)) == null || !((Boolean)wbData.get("isNeedWB")).booleanValue()) continue;
                entry.set("basearqty", wbData.get("wbQty"));
                BigDecimal arQty = MaterialHelper.getDesQtyConv((Long)((Long)material.getDynamicObject("masterid").getPkValue()), (DynamicObject)baseunit, (BigDecimal)((BigDecimal)wbData.get("wbQty")), (DynamicObject)unit, (boolean)true);
                entry.set("joinpriceqty", (Object)arQty);
                entry.set("aramount", wbData.get("wbAmount"));
                String field1 = ResManager.loadKDString((String)"\u5e94\u6536\u6570\u91cf", (String)"WbSoService_4", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                String field2 = ResManager.loadKDString((String)"\u6570\u91cf", (String)"WbSoService_5", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                this.setWarnLog(bill.getString("billno"), entry.getString("seq"), field1, arQty, field2, qty);
                String field3 = ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"WbSoService_6", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                String field4 = ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"WbSoService_7", (String)"scmc-sm-mservice", (Object[])new Object[0]);
                this.setWarnLog(bill.getString("billno"), entry.getString("seq"), field3, arAmount, field4, amountandtax);
            }
        }
        return beforeBills;
    }
}

