/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.mservice.wbso.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.sm.mservice.wbso.WbSoService;
import kd.scmc.sm.mservice.wbso.pojo.WbSoParam;

public class WbSOPreRecAct
extends WbSoService {
    public WbSOPreRecAct() {
        this.wbBillType = "REC";
    }

    @Override
    protected String getSelectFields() {
        List<String> selectors = Arrays.asList("id", "billno", "totalallamount", "prereceiptamount", "receiptamount", "billentry.id", "billentry.seq", "recplanentry.r_recamount");
        return String.join((CharSequence)",", selectors);
    }

    @Override
    protected List<String> checkParam(List<WbSoParam> params) {
        return this.defaultParamCheck(params);
    }

    @Override
    protected DynamicObject[] genWbBill(Map<Long, List<WbSoParam>> paramMap, DynamicObject[] beforeBills) {
        if (beforeBills == null || paramMap == null) {
            return null;
        }
        for (DynamicObject bill : beforeBills) {
            BigDecimal totalallamount = bill.getBigDecimal("totalallamount");
            BigDecimal preRecAmount = bill.getBigDecimal("prereceiptamount");
            BigDecimal recAmount = bill.getBigDecimal("receiptamount");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("recplanentry");
            for (DynamicObject entry : entrys) {
                List<WbSoParam> paramList = paramMap.get(entry.getPkValue());
                BigDecimal recEntryAmount = entry.getBigDecimal("r_recamount");
                if (paramList != null) {
                    for (WbSoParam param : paramList) {
                        preRecAmount = preRecAmount.add(param.getWbAmount());
                        recAmount = recAmount.add(param.getWbAmount());
                        recEntryAmount = recEntryAmount.add(param.getWbAmount());
                    }
                }
                entry.set("r_recamount", (Object)recEntryAmount);
            }
            bill.set("prereceiptamount", (Object)preRecAmount);
            bill.set("receiptamount", (Object)recAmount);
            String field = ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"WbSoService_7", (String)"scmc-sm-mservice", (Object[])new Object[0]);
            String field1 = ResManager.loadKDString((String)"\u5df2\u9884\u6536\u91d1\u989d", (String)"WbSoService_10", (String)"scmc-sm-mservice", (Object[])new Object[0]);
            this.setWarnLog(bill.getString("billno"), null, field1, preRecAmount, field, totalallamount);
            String field2 = ResManager.loadKDString((String)"\u5df2\u6536\u91d1\u989d", (String)"WbSoService_11", (String)"scmc-sm-mservice", (Object[])new Object[0]);
            this.setWarnLog(bill.getString("billno"), null, field2, recAmount, field, totalallamount);
        }
        return beforeBills;
    }
}

