/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class UpmMasterFileLogUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        Set<Long> masterFileIds = this.listMasterFilesId();
        DataSet upmExecuteLogs = this.queryUpmExecuteLog(masterFileIds);
        ArrayList<Object[]> values = new ArrayList<Object[]>(16);
        for (Row log : upmExecuteLogs) {
            Object[] value = new Object[]{DBServiceHelper.genGlobalLongId(), log.getLong("id"), log.getLong("masterfile")};
            values.add(value);
        }
        if (ObjectUtils.isEmpty(values)) {
            return result;
        }
        String insertSql = "INSERT INTO T_UPM_WB_EXELOGFILE(FPKID,FID,FBASEDATAID) VALUES (?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)insertSql, values);
        return result;
    }

    private DataSet queryUpmExecuteLog(Set<Long> masterFileIds) {
        return QueryServiceHelper.queryDataSet((String)"queryMasterFile", (String)"upm_wb_exelog", (String)"id,masterfile", (QFilter[])new QFilter[]{new QFilter("id", "not in", masterFileIds)}, null);
    }

    private Set<Long> listMasterFilesId() {
        HashSet<Long> result = new HashSet<Long>(16);
        DataSet rows = DB.queryDataSet((String)"listMasterFilesId", (DBRoute)DBRoute.of((String)"scm"), (String)"select fid from T_UPM_WB_EXELOGFILE");
        for (Row row : rows) {
            result.add(row.getLong("fid"));
        }
        return result;
    }
}

