/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.servicehelper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new KDBizException(String.format(ServiceFactory.getServiceFactoryServerImplStr(), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    private static String getServiceFactoryServerImplStr() {
        return ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"scmc-upm-mservice", (Object[])new Object[0]);
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    static {
        serviceMap.put("UpmMasterfileService", "kd.scmc.upm.mservice.UpmMasterfileServiceImpl");
        serviceMap.put("UpmBillValidateService", "kd.scmc.upm.mservice.UpmBillValidateServiceImpl");
        serviceMap.put("UpmBillOperateService", "kd.scmc.upm.mservice.UpmBillOperateServiceImpl");
        serviceMap.put("UpmMasterAcitionService", "kd.scmc.upm.mservice.UpmMasterAcitionServiceImpl");
        serviceMap.put("UpmMasterFileLogUpgradePlugin", "kd.scmc.upm.mservice.upgrade.UpmMasterFileLogUpgradePlugin");
    }
}

