/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.upm.business.actionform.MasterActionFormCfg;
import kd.scmc.upm.common.util.ActionFormUtil;
import kd.scmc.upm.common.util.OpServiceUtil;

public class CreateBizBillHelper {
    public static DynamicObject getMaterialInfo(long orgId, DynamicObject material, MainEntityType mainEntityType) {
        IDataEntityProperty property = mainEntityType.findProperty("material");
        if (!(property instanceof BasedataProp)) {
            return null;
        }
        String baseEntityId = ((BasedataProp)property).getBaseEntityId();
        if ("bd_material".equals(baseEntityId)) {
            return material;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)baseEntityId, (Long)orgId);
        DynamicObject[] materialinventory = BusinessDataServiceHelper.load((String)baseEntityId, (String)"id,ctrlstrategy", (QFilter[])new QFilter[]{new QFilter("masterid.id", "=", (Object)material.getLong("masterid")), baseDataFilter});
        DynamicObject materialInfo = null;
        String privateCtrlStrategy = "7";
        DynamicObject[] dynamicObjectArray = materialinventory;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject;
            materialInfo = dynamicObject = dynamicObjectArray[i];
            String ctrlStrategy = dynamicObject.getString("ctrlstrategy");
            if (privateCtrlStrategy.equals(ctrlStrategy)) break;
        }
        return materialInfo;
    }

    public static DynamicObject getTargetEntity(Long actionId) {
        DynamicObject action = BusinessDataServiceHelper.loadSingle((Object)actionId, (String)"upm_masteraction");
        DynamicObjectCollection actionEntry = action.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : actionEntry) {
            DynamicObject srcObj = row.getDynamicObject("bizopservice").getDynamicObject("srcobj");
            if (srcObj == null) continue;
            return srcObj;
        }
        return null;
    }

    public static DynamicObject getNewBizBill(String targetEntity) {
        long id = DBServiceHelper.genGlobalLongId();
        DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)targetEntity);
        dataInfo.set("id", (Object)id);
        String newBillNo = CodeRuleServiceHelper.getNumber((String)targetEntity, (DynamicObject)dataInfo, null);
        dataInfo.set("billno", (Object)newBillNo);
        return dataInfo;
    }

    public static DynamicObject getActionFormCfg(long actionId) {
        QFilter filter = new QFilter("masteraction", "=", (Object)actionId);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingle((String)"upm_actionformcfg", (QFilter[])filter.toArray());
    }

    public static Map<String, Long> getCurrencyInfo(Long mainOrgId) {
        Map map;
        Map mapOrg;
        Map currencyInfo = null;
        if (mainOrgId != 0L && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)mainOrgId, (Boolean)false, (Boolean)true)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            currencyInfo = map;
        }
        return currencyInfo;
    }

    public static void addActionCfgParams(Map<String, Object> valueParams, String formId, MasterActionFormCfg actionFormCfg, DynamicObject dataEntity) {
        if (actionFormCfg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52a8\u4f5c\u754c\u9762\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"CreateBizBillHelper_0", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        List<MasterActionFormCfg.ActionFormField> actionFormFieldList = actionFormCfg.getActionFormFieldList();
        for (MasterActionFormCfg.ActionFormField actionFormField : actionFormFieldList) {
            Object value;
            String fieldKey = actionFormField.getFieldKey();
            String defaultVal = actionFormField.getDefaultVal();
            IDataEntityProperty property = mainEntityType.findProperty(fieldKey);
            if (property == null || !formId.equals(actionFormField.getEntityType())) continue;
            Object object = value = dataEntity == null ? ActionFormUtil.dealWithDefaultVal(property, defaultVal) : ActionFormUtil.getValue(dataEntity.get(fieldKey));
            if (property.getParent() instanceof EntryType) {
                String entryName = property.getParent().getName();
                if (!valueParams.containsKey(entryName)) {
                    valueParams.put(entryName, new HashMap());
                }
                Map entryMap = (Map)valueParams.get(entryName);
                entryMap.put(fieldKey, value);
                continue;
            }
            valueParams.put(fieldKey, value);
        }
    }

    public static void addInvBalParams(Map<String, Object> valueParams, String formId, MasterActionFormCfg actionFormCfg, long masterId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        DynamicObject masterFile = BusinessDataServiceHelper.loadSingle((Object)masterId, (String)"upm_masterfile");
        long mappingCfgId = actionFormCfg.getMappingCfg();
        DynamicObject mapping = BusinessDataServiceHelper.loadSingle((Object)mappingCfgId, (String)"sbs_billfieldmapping");
        DynamicObjectCollection cols = mapping.getDynamicObjectCollection("colsmap");
        HashMap<String, String> targetSrcColMap = new HashMap<String, String>(16);
        HashSet<String> balFieldSet = new HashSet<String>(16);
        for (DynamicObject row : cols) {
            String targetKey = row.getString("targetobjcol");
            String sourceKey = row.getString("sourcebillcol");
            balFieldSet.add(sourceKey);
            targetSrcColMap.put(targetKey, sourceKey);
        }
        String balFieldKey = actionFormCfg.getBalFieldKey();
        QFilter filter = new QFilter(balFieldKey, "=", (Object)masterFile.getString("number"));
        filter.and("baseqty", ">", (Object)0);
        String selectFields = StringUtils.join((Object[])balFieldSet.toArray(), (String)",");
        DynamicObject realBalDyo = QueryServiceHelper.queryOne((String)"im_inv_realbalance", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (realBalDyo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5373\u65f6\u4f59\u989d\u5e93\u5b58\u8868\u4e2d\u6ca1\u6709\u4e3b\u6863\u5173\u8054\u7684\u6570\u636e", (String)"UpmCreateBillActionFormPlugin_2", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
        for (Map.Entry entry : targetSrcColMap.entrySet()) {
            String billKey = (String)entry.getKey();
            String balKey = (String)entry.getValue();
            if (billKey.contains(".")) {
                HashMap<String, Object> entryMap;
                String[] split = billKey.split("\\.");
                String entryName = split[0];
                String entryKey = split[1];
                if (valueParams.containsKey(entryName)) {
                    entryMap = (HashMap<String, Object>)valueParams.get(entryName);
                } else {
                    entryMap = new HashMap<String, Object>(16);
                    valueParams.put(entryName, entryMap);
                }
                if ("material".equals(entryKey)) {
                    DynamicObject materialInfo = CreateBizBillHelper.getMaterialInfo(realBalDyo.getLong("org"), masterFile.getDynamicObject("material"), mainEntityType);
                    if (materialInfo == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u672a\u751f\u6210\u5bf9\u5e94\u7b56\u7565\u4fe1\u606f", (String)"UpmCreateBillActionFormPlugin_1", (String)"scmc-upm-form", (Object[])new Object[0]));
                    }
                    entryMap.put(entryKey, materialInfo.getLong("id"));
                    continue;
                }
                entryMap.put(entryKey, realBalDyo.get(balKey));
                continue;
            }
            valueParams.put(billKey, realBalDyo.get(balKey));
        }
    }

    public static void addMainOrgCurrencyParam(Map<String, Object> valueParams, String formId, MasterActionFormCfg actionFormCfg) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        List<MasterActionFormCfg.ActionFormField> actionFormFieldList = actionFormCfg.getActionFormFieldList();
        String currencyId = "";
        for (MasterActionFormCfg.ActionFormField actionFormField : actionFormFieldList) {
            String fieldKey = actionFormField.getFieldKey();
            IDataEntityProperty property = mainEntityType.findProperty(fieldKey);
            if (!(property instanceof BasedataProp) || !"bd_currency".equals(((BasedataProp)property).getBaseEntityId())) continue;
            currencyId = fieldKey;
        }
        String mainOrg = mainEntityType.getMainOrg();
        Long mainOrgId = (Long)valueParams.get(mainOrg);
        Map<String, Long> currencyInfo = CreateBizBillHelper.getCurrencyInfo(mainOrgId);
        if (currencyInfo != null && !"".equals(currencyId)) {
            valueParams.put(currencyId, currencyInfo.get("baseCurrencyID"));
        } else {
            valueParams.put(currencyId, 1L);
        }
    }

    public static long generateBill(String formId, MasterActionFormCfg actionFormCfg, long masterId) {
        HashMap<String, Object> valueParams = new HashMap<String, Object>(16);
        CreateBizBillHelper.addActionCfgParams(valueParams, formId, actionFormCfg, null);
        CreateBizBillHelper.addInvBalParams(valueParams, formId, actionFormCfg, masterId);
        CreateBizBillHelper.addMainOrgCurrencyParam(valueParams, formId, actionFormCfg);
        long id = DBServiceHelper.genGlobalLongId();
        DynamicObject billInfo = BusinessDataServiceHelper.newDynamicObject((String)formId);
        billInfo.set("id", (Object)id);
        String newBillNo = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)billInfo, null);
        billInfo.set("billno", (Object)newBillNo);
        billInfo.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        billInfo = OpServiceUtil.getDynamic4Map(valueParams, formId, billInfo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billInfo});
        return id;
    }
}

