/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.upm.business.action.MasterAcitonModel;
import kd.scmc.upm.business.action.MasterAcitonResult;
import kd.scmc.upm.common.consts.UpmMasterActionServiceConst;
import kd.scmc.upm.common.consts.UpmStateField;

public class MasterRelationHelper {
    public static QFilter getActionFilter(Map<String, Object> masterStaMap, Long relationId) {
        QFilter actFilter = new QFilter("1", "!=", (Object)1);
        if (masterStaMap == null || masterStaMap.isEmpty() || relationId == null || relationId.equals(0L)) {
            return actFilter;
        }
        QFilter relationF = new QFilter("id", "=", (Object)relationId);
        QFilter enableF = new QFilter("entryentity.isenable", "=", (Object)Boolean.TRUE);
        QFilter statusF = new QFilter("entryentity.oldstatus", "=", (Object)UpmMasterActionServiceConst.NULL_STATUSID);
        for (Map.Entry<String, Object> masterStatus : masterStaMap.entrySet()) {
            QFilter entryFilter = new QFilter("entryentity.updstafield", "=", (Object)masterStatus.getKey()).and("entryentity.oldstatus", "=", masterStatus.getValue());
            statusF.or(entryFilter);
        }
        DynamicObjectCollection masterRelations = QueryServiceHelper.query((String)"upm_masterrelation", (String)"entryentity.action,entryentity.updstafield,entryentity.oldstatus", (QFilter[])relationF.and(enableF).and(statusF).toArray());
        UpmStateField field = new UpmStateField(relationId, (Long)masterStaMap.get("mainstatus"), (Long)masterStaMap.get("secondarystatus"));
        Set<Long> actIds = MasterRelationHelper.listActionId(field, masterRelations);
        if (actIds.isEmpty()) {
            return actFilter;
        }
        actFilter = new QFilter("id", "in", actIds);
        return actFilter;
    }

    private static Set<Long> listActionId(UpmStateField stateField, DynamicObjectCollection masterRelations) {
        Set actMap;
        HashSet<Long> actIds = new HashSet<Long>(16);
        HashMap<Long, Set> actMaps = new HashMap<Long, Set>(16);
        for (Object masterRelation : masterRelations) {
            Long l = masterRelation.getLong("entryentity.action");
            String updField = masterRelation.getString("entryentity.updstafield");
            if (!MasterRelationHelper.isMatchState(stateField, (DynamicObject)masterRelation)) continue;
            actMap = actMaps.getOrDefault(l, new HashSet(16));
            actMap.add(updField);
            if (actMaps.containsKey(l)) continue;
            actMaps.put(l, actMap);
        }
        HashMap<Long, Set> partMatchActMaps = new HashMap<Long, Set>(actMaps.size());
        for (Map.Entry entry : actMaps.entrySet()) {
            Long actId = (Long)entry.getKey();
            actMap = (Set)entry.getValue();
            if (actMap.size() < 2) {
                partMatchActMaps.put(actId, actMap);
            }
            actIds.add(actId);
        }
        if (!ObjectUtils.isEmpty(partMatchActMaps)) {
            HashSet<Long> remActIds = new HashSet<Long>(partMatchActMaps.size());
            for (DynamicObject row : masterRelations) {
                Long actId = row.getLong("entryentity.action");
                if (!partMatchActMaps.containsKey(actId)) continue;
                String updField = row.getString("entryentity.updstafield");
                Set actMap2 = (Set)partMatchActMaps.get(actId);
                if (actMap2.contains(updField)) continue;
                remActIds.add(actId);
            }
            actIds.removeAll(remActIds);
        }
        return actIds;
    }

    public static DynamicObjectCollection getMasterRelations(DynamicObject masterInfo, DynamicObject action) {
        QFilter actF = new QFilter("entryentity.action", "=", action.getPkValue());
        QFilter enableF = new QFilter("entryentity.isenable", "=", (Object)Boolean.TRUE);
        QFilter staF = null;
        IDataEntityType entityType = masterInfo.getDataEntityType();
        for (IDataEntityProperty pro : entityType.getProperties()) {
            if (!(pro instanceof BasedataProp)) continue;
            String entityId = ((BasedataProp)pro).getBaseEntityId();
            String proName = pro.getName();
            if (!"upm_masterstatus".equals(entityId)) continue;
            QFilter staEntryF = new QFilter("updstafield", "=", (Object)masterInfo.getLong(proName + "_id"));
            if (staF == null) {
                staF = staEntryF;
                continue;
            }
            staF = staF.or(staEntryF);
        }
        if (staF == null) {
            return null;
        }
        return QueryServiceHelper.query((String)"upm_masterrelation", (String)"entryentity.newstatus,entryentity.updstafield", (QFilter[])actF.and(enableF).and(staF).toArray());
    }

    public static void updMasterStatus(DynamicObject masterInfo, DynamicObjectCollection masterRelation) {
        for (DynamicObject relationEntry : masterRelation) {
            String staKey = relationEntry.getString("entryentity.updstafield");
            long staVal = relationEntry.getLong("entryentity.newstatus");
            DynamicObject sta = BusinessDataServiceHelper.newDynamicObject((String)"upm_masterstatus");
            sta.set("id", (Object)staVal);
            masterInfo.set(staKey, (Object)sta);
        }
    }

    public static void updMasterStatus(DynamicObject masterInfo, DynamicObject action) {
        DynamicObjectCollection masterRelations = MasterRelationHelper.getMasterRelations(masterInfo, action);
        if (masterRelations == null || masterRelations.isEmpty()) {
            return;
        }
        MasterRelationHelper.updMasterStatus(masterInfo, masterRelations);
    }

    public static MasterAcitonResult execAction(List<Object[]> paramsList, Long actionId, Long exeLogId) {
        MasterAcitonModel masterAcitonModel = MasterAcitonModel.getInstance(paramsList, actionId, exeLogId);
        masterAcitonModel.execute();
        return masterAcitonModel.getAcitonResult();
    }

    public static Set<Long> listMatchedActionId(List<UpmStateField> stateFields) {
        Map<Long, DynamicObjectCollection> masterRelationIdToDynamicMap = MasterRelationHelper.getMasterRelationIdToDynamicMap(stateFields);
        Set<Long> commonActionIds = new HashSet<Long>(16);
        for (UpmStateField stateField : stateFields) {
            DynamicObjectCollection masterRelation = masterRelationIdToDynamicMap.get(stateField.getMasterRelationId());
            if (ObjectUtils.isEmpty((Object)masterRelation)) {
                return Collections.emptySet();
            }
            Set<Long> matchedActionIds = MasterRelationHelper.listActionId(stateField, masterRelation);
            if (ObjectUtils.isEmpty(commonActionIds)) {
                commonActionIds = matchedActionIds;
            }
            if (!ObjectUtils.isEmpty(commonActionIds = commonActionIds.stream().filter(matchedActionIds::contains).collect(Collectors.toSet()))) continue;
            return Collections.emptySet();
        }
        commonActionIds = MasterRelationHelper.listUsableAction(stateFields.size() > 1, commonActionIds);
        return commonActionIds;
    }

    private static boolean isMatchState(UpmStateField stateField, DynamicObject masterRelationRow) {
        String updField = masterRelationRow.getString("entryentity.updstafield");
        long oldStatusId = masterRelationRow.getLong("entryentity.oldstatus");
        if (stateField.getMainStateFiled().equals(updField) && stateField.getMainStateId() == oldStatusId) {
            return true;
        }
        if (stateField.getSecondaryStateField().equals(updField) && stateField.getSecondaryStateId() == oldStatusId) {
            return true;
        }
        return oldStatusId == UpmMasterActionServiceConst.NULL_STATUSID;
    }

    private static Map<Long, DynamicObjectCollection> getMasterRelationIdToDynamicMap(List<UpmStateField> stateFields) {
        Set relationIds = stateFields.stream().map(UpmStateField::getMasterRelationId).collect(Collectors.toSet());
        DynamicObjectCollection upmMasterRelations = QueryServiceHelper.query((String)"upm_masterrelation", (String)"id, entryentity.action,entryentity.updstafield,entryentity.oldstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", relationIds), new QFilter("entryentity.isenable", "=", (Object)Boolean.TRUE)}, null);
        HashMap<Long, DynamicObjectCollection> result = new HashMap<Long, DynamicObjectCollection>(16);
        for (DynamicObject upmMasterRelation : upmMasterRelations) {
            DynamicObjectCollection collection = result.getOrDefault(upmMasterRelation.getLong("id"), new DynamicObjectCollection());
            collection.add((Object)upmMasterRelation);
            result.put(upmMasterRelation.getLong("id"), collection);
        }
        return result;
    }

    public static List<UpmStateField> listUpmStateField(int[] selectRows, DynamicObjectCollection entry) {
        ArrayList<UpmStateField> stateFields = new ArrayList<UpmStateField>(16);
        for (int rowIndex : selectRows) {
            DynamicObject entryRow = (DynamicObject)entry.get(rowIndex);
            DynamicObject mainStatus = entryRow.getDynamicObject("mainstatus");
            DynamicObject secondaryStatus = entryRow.getDynamicObject("secondarystatus");
            DynamicObject masterRelation = entryRow.getDynamicObject("masterrelation");
            long relationId = ObjectUtils.isEmpty((Object)masterRelation) ? 0L : masterRelation.getLong("id");
            long mainStatusId = ObjectUtils.isEmpty((Object)mainStatus) ? 0L : mainStatus.getLong("id");
            long secondaryStatusId = ObjectUtils.isEmpty((Object)secondaryStatus) ? 0L : secondaryStatus.getLong("id");
            stateFields.add(new UpmStateField(relationId, mainStatusId, secondaryStatusId));
        }
        return stateFields;
    }

    private static Set<Long> listUsableAction(boolean isBatch, Set<Long> commonActionIds) {
        if (!isBatch) {
            return commonActionIds;
        }
        HashSet<Long> result = new HashSet<Long>(16);
        DynamicObjectCollection upmActions = QueryServiceHelper.query((String)"upm_masteraction", (String)"id,entryentity.bizopservice.actiontype", (QFilter[])new QFilter[]{new QFilter("id", "in", commonActionIds)});
        for (DynamicObject upmAction : upmActions) {
            String actionType = upmAction.getString("entryentity.bizopservice.actiontype");
            if (!Arrays.asList("BIZOP", "SERVICE", "PRINT", "LOAD").contains(actionType)) continue;
            result.add(upmAction.getLong("id"));
        }
        return result;
    }
}

