/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MasterfileBillConfigHelper {
    public static Collection<DynamicObject> getBillConfig(String formid, String operate) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"upm_billconf", (QFilter[])new QFilter("srcbillobj", "=", (Object)formid).and("operate", "=", (Object)operate).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted((cfg1, cfg2) -> {
            Long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }).collect(Collectors.toList());
    }

    public static QFilter parseBillFilter(String jsonCondition, String billtype) {
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        fb.buildFilter();
        return fb.getQFilter();
    }

    public static LinkedHashMap<String, String> getMainfMaps(DynamicObject cfg, String srctype) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("mainfentry");
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>(entries.size());
        for (DynamicObject entry : entries) {
            String mainfsrctype = entry.getString("mainfsrctype");
            String mainfcol = entry.getString("mainfcol");
            if ("material".equals(mainfcol) || !srctype.equals(mainfsrctype)) continue;
            switch (srctype) {
                case "A": {
                    maps.put(mainfcol, entry.getString("mainfsrcbillcol"));
                    break;
                }
                case "B": {
                    maps.put(mainfcol, entry.getString("mainfdefvalid"));
                }
            }
        }
        return maps;
    }

    public static LinkedHashMap<String, String> getTrackMaps(DynamicObject cfg, String srctype) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("trackentry");
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>(entries.size());
        for (DynamicObject entry : entries) {
            String tracksrctype = entry.getString("tracksrctype");
            if (!srctype.equals(tracksrctype)) continue;
            switch (srctype) {
                case "A": {
                    maps.put(entry.getString("trackcol"), entry.getString("tracksrcbillcol"));
                    break;
                }
                case "B": {
                    maps.put(entry.getString("trackcol"), entry.getString("trackdefvalid"));
                }
            }
        }
        return maps;
    }

    public static String getMaterialCol(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("mainfentry");
        for (DynamicObject entry : entries) {
            String mainfcol = entry.getString("mainfcol");
            if (!"material".equals(mainfcol)) continue;
            return entry.getString("mainfsrcbillcol");
        }
        return null;
    }

    public static String getOrgCol(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("mainfentry");
        for (DynamicObject entry : entries) {
            String mainfcol = entry.getString("mainfcol");
            if (!"org".equals(mainfcol)) continue;
            return entry.getString("mainfsrcbillcol");
        }
        return null;
    }

    public static String getEntryPath(MainEntityType mainEntityType, String entrytype) {
        EntityType entry = (EntityType)mainEntityType.getAllEntities().get(entrytype);
        IDataEntityType parent = entry.getParent();
        if (parent instanceof MainEntityType) {
            return entrytype;
        }
        return parent.getName() + '.' + entrytype;
    }

    public static Map<String, Set<String>> getBillCfgsMatchMap(String billtype, Collection<DynamicObject> cfgs, List<Long> billIds) {
        HashMap<String, Set<String>> billCfgsMap = new HashMap<String, Set<String>>(billIds.size() * 2);
        for (DynamicObject cfg : cfgs) {
            String identPre = cfg.getString("srcbillentry") + '.';
            QFilter filter = new QFilter("id", "in", billIds);
            QFilter cfgFilter = MasterfileBillConfigHelper.parseBillFilter(cfg.getString("billfilter"), billtype);
            if (cfgFilter != null) {
                filter.and(cfgFilter);
            }
            DynamicObjectCollection bills = QueryServiceHelper.query((String)billtype, (String)"id", (QFilter[])filter.toArray());
            for (DynamicObject bill : bills) {
                Long billId = bill.getLong("id");
                String ident = identPre + billId;
                Set cfgSet = billCfgsMap.getOrDefault(ident, new HashSet(3));
                cfgSet.add(cfg.getString("number"));
                if (billCfgsMap.containsKey(ident)) continue;
                billCfgsMap.put(ident, cfgSet);
            }
        }
        return billCfgsMap;
    }

    public static boolean isDynamicObjectMatchCfg(String billtype, DynamicObject billObj, DynamicObject cfg) {
        String jsonCondition = cfg.getString("billfilter");
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return true;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        if (filterCondition.getFilterRow().isEmpty()) {
            return true;
        }
        MainEntityType mainType = (MainEntityType)billObj.getDataEntityType();
        FilterBuilder builder = new FilterBuilder(mainType, filterCondition);
        String[] script = builder.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        RowDataModel rowModel = new RowDataModel(billtype, mainType);
        BOSExpressionContext expContext = new BOSExpressionContext(rowModel);
        expContext.getRowDataModel().setRowContext((Object)billObj, 0);
        Boolean result = (Boolean)CalcExprParser.getExpressionValue((BOSExpression)expr, (ExpressionContext)expContext, (FunctionManage)FunctionManage.get());
        return result;
    }
}

