/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.upm.business.actionform.ActionFormCfgHelper;
import kd.scmc.upm.common.util.OpServiceUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PushServiceHelper {
    private static final Log log = LogFactory.getLog(PushServiceHelper.class);

    public static DynamicObject pushAndSave(Long masterfileId, Long masterActionId) {
        DynamicObject botpDym = ActionFormCfgHelper.getBotpRule(masterActionId);
        if (null == botpDym) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u6863\u52a8\u4f5c\u672a\u914d\u7f6ebotp\u89c4\u5219\u3002", (String)"PushServiceHelper_0", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
        String sourceEntityType = PushServiceHelper.getSourceEntityType(botpDym);
        DynamicObject moveTrackDym = PushServiceHelper.findMoveTrack(masterfileId, sourceEntityType);
        if (null == moveTrackDym) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4e3b\u6863\u4e0d\u5b58\u5728%s\u7684\u8f68\u8ff9\u3002", (String)"UpmWorkbenchPlugin_10", (String)"scmc-upm-form", (Object[])new Object[0]), sourceEntityType));
        }
        Long billId = moveTrackDym.getLong("billid");
        String entryType = moveTrackDym.getString("billentrytype");
        Long entryId = moveTrackDym.getLong("billentryid");
        List<DynamicObject> billList = PushServiceHelper.push(botpDym.getPkValue(), billId, entryType, entryId);
        if (null == billList || billList.isEmpty()) {
            return null;
        }
        billList = PushServiceHelper.assignAndSaveMasterFileNumber(billList, masterfileId, masterActionId);
        return billList.get(0);
    }

    private static DynamicObject findMoveTrack(Long masterFileId, String srcEntityNumber) {
        QFilter qFilter = new QFilter("masterfileid", "=", (Object)masterFileId);
        qFilter.and("billtype", "=", (Object)srcEntityNumber);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"upm_movetrack", (String)"billid,billentrytype,billentryid,billno", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1);
        if (ObjectUtils.isEmpty((Object)collection)) {
            return null;
        }
        return (DynamicObject)collection.get(0);
    }

    private static List<DynamicObject> push(Object botpId, Long billId, String entryType, Long entryId) {
        MainEntityType targetEntityType;
        List dynamicObjectList;
        ConvertOperationResult convertOperationResult;
        log.info("botp\uff1a{}, src\uff1a{}, entryType\uff1a{}, entryId\uff1a{}", new Object[]{botpId, billId, entryType, entryId});
        DynamicObject botpRuleDym = BusinessDataServiceHelper.loadSingleFromCache((Object)botpId, (String)"botp_crlist");
        if (null == botpRuleDym) {
            log.info("botp\u89c4\u5219\u5bf9\u8c61\u4e3a\u7a7a");
            return null;
        }
        try {
            PushArgs args = PushServiceHelper.buildArgs(botpRuleDym, billId, entryType, entryId);
            convertOperationResult = ConvertServiceHelper.push((PushArgs)args);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (!convertOperationResult.isSuccess()) {
            StringBuilder reports = new StringBuilder();
            for (SourceBillReport billReport : convertOperationResult.getBillReports()) {
                reports.append(billReport.toString());
            }
            throw new KDBizException(reports.toString());
        }
        String targetEntityNumber = PushServiceHelper.getTargetEntityType(botpRuleDym);
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)targetEntityNumber, (DynamicObject[])(dynamicObjectList = convertOperationResult.loadTargetDataObjects((dynamicObjects, dType) -> BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType), targetEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntityNumber))).toArray(new DynamicObject[dynamicObjectList.size()]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            StringBuilder reports = new StringBuilder(operationResult.getMessage());
            for (IOperateInfo operateInfo : operationResult.getAllErrorOrValidateInfo()) {
                reports.append(operateInfo.getMessage());
            }
            throw new KDBizException(reports.toString());
        }
        return dynamicObjectList;
    }

    private static PushArgs buildArgs(DynamicObject botpRuleDym, Long billId, String entryType, Long entryId) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(PushServiceHelper.getSourceEntityType(botpRuleDym));
        pushArgs.setTargetEntityNumber(PushServiceHelper.getTargetEntityType(botpRuleDym));
        pushArgs.setRuleId(botpRuleDym.getString("id"));
        pushArgs.setSelectedRows(PushServiceHelper.buildSelectedRows(billId, entryType, entryId));
        pushArgs.setHasRight(true);
        pushArgs.setBuildConvReport(true);
        return pushArgs;
    }

    private static List<ListSelectedRow> buildSelectedRows(Long billId, String entryType, Long entryId) {
        ListSelectedRow row = new ListSelectedRow((Object)billId, Boolean.TRUE);
        row.setEntryEntityKey(entryType);
        row.setEntryPrimaryKeyValue((Object)entryId);
        return Collections.singletonList(row);
    }

    private static String getTargetEntityType(DynamicObject botpRuleDym) {
        return (String)botpRuleDym.getDynamicObject("targetentitynumber").getPkValue();
    }

    private static String getSourceEntityType(DynamicObject botpRuleDym) {
        return (String)botpRuleDym.getDynamicObject("sourceentitynumber").getPkValue();
    }

    private static List<DynamicObject> assignAndSaveMasterFileNumber(List<DynamicObject> billList, Long masterfileId, Long actionId) {
        DynamicObject actionFormDym = ActionFormCfgHelper.loadCfg(actionId);
        if (null == actionFormDym) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52a8\u4f5c\u754c\u9762\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"CreateBizBillHelper_0", (String)"scmc-upm-form", (Object[])new Object[0]));
        }
        String balfielkey = actionFormDym.getString("balfieldkey");
        if (StringUtils.isBlank((CharSequence)balfielkey)) {
            return billList;
        }
        DynamicObject masterfileDym = BusinessDataServiceHelper.loadSingle((Object)masterfileId, (String)"upm_masterfile", (String)"number");
        MainEntityType mainEntityType = (MainEntityType)billList.get(0).getDataEntityType();
        String entityName = mainEntityType.getName();
        String masterFileNumber = masterfileDym.getString("number");
        IDataEntityProperty assignProp = mainEntityType.findProperty(balfielkey);
        if (null == assignProp) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5b9e\u4f53%1$s\u4e0d\u5b58\u5728%2$s\u5c5e\u6027\u3002", (String)"PushServiceHelper_1", (String)"scmc-upm-form", (Object[])new Object[0]), entityName, balfielkey));
        }
        HashMap<String, Object> propValMap = new HashMap<String, Object>(1);
        if (assignProp.getParent() instanceof EntryType) {
            IDataEntityType entityType = assignProp.getParent();
            propValMap.put(entityType.getName(), Collections.singletonMap(balfielkey, masterFileNumber));
        } else {
            propValMap.put(balfielkey, masterFileNumber);
        }
        for (DynamicObject bill : billList) {
            OpServiceUtil.getDynamic4Map(propValMap, entityName, bill);
        }
        if (MapUtils.isNotEmpty(propValMap)) {
            Object[] result = SaveServiceHelper.save((DynamicObject[])billList.toArray(new DynamicObject[0]));
            return Stream.of(result).map(item -> (DynamicObject)item).collect(Collectors.toList());
        }
        return billList;
    }
}

