/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.upm.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class RoleDataIsolationHelper {
    public static List<Long> getUserRoleList() {
        return RoleDataIsolationHelper.getUserRoleList(null);
    }

    public static List<Long> getUserRoleList(Long userId) {
        if (userId == null || userId == 0L) {
            userId = UserServiceHelper.getCurrentUserId();
        }
        QFilter qfilter = new QFilter("userid", "=", (Object)userId);
        Map userRoleMap = BusinessDataServiceHelper.loadFromCache((String)"upm_userrole", (QFilter[])qfilter.toArray());
        List<Long> roleIdList = userRoleMap.values().stream().filter(row -> row.getDynamicObject("roleid").getString("enable").equals("1")).map(v -> (Long)v.getDynamicObject("roleid").getPkValue()).collect(Collectors.toList());
        return roleIdList;
    }

    public static List<Long> getUserRoleOrgList(Long userId) {
        if (userId == null || userId == 0L) {
            userId = UserServiceHelper.getCurrentUserId();
        }
        QFilter roleQFilter = new QFilter("userid", "=", (Object)userId);
        Map userRoleMap = BusinessDataServiceHelper.loadFromCache((String)"upm_userrole", (QFilter[])roleQFilter.toArray());
        List roleIdList = userRoleMap.values().stream().filter(row -> row.getDynamicObject("roleid").getString("enable").equals("1")).map(v -> (Long)v.getDynamicObject("roleid").getPkValue()).collect(Collectors.toList());
        QFilter orgQFilter = new QFilter("roleid", "in", roleIdList);
        Map roleOrgMap = BusinessDataServiceHelper.loadFromCache((String)"upm_roleorg", (QFilter[])orgQFilter.toArray());
        List<Long> orgIdList = roleOrgMap.values().stream().map(v -> (Long)v.getDynamicObject("orgid").getPkValue()).collect(Collectors.toList());
        return orgIdList;
    }

    public static List<Long> getRoleOrgList(List<Long> roleIdList) {
        if (roleIdList == null || roleIdList.size() <= 0) {
            return new ArrayList<Long>(16);
        }
        QFilter orgQFilter = new QFilter("roleid", "in", roleIdList);
        Map roleOrgMap = BusinessDataServiceHelper.loadFromCache((String)"upm_roleorg", (QFilter[])orgQFilter.toArray());
        List<Long> orgIdList = roleOrgMap.values().stream().map(v -> (Long)v.getDynamicObject("orgid").getPkValue()).collect(Collectors.toList());
        return orgIdList;
    }

    public static List<Long> getRoleOrgList(Long roleId) {
        ArrayList<Long> roleIdList = new ArrayList<Long>(16);
        if (roleId == null || roleId == 0L) {
            return roleIdList;
        }
        roleIdList.add(roleId);
        return RoleDataIsolationHelper.getRoleOrgList(roleIdList);
    }

    public static List<Long> getRoleVehicleList(List<Long> roleIdList) {
        if (roleIdList == null || roleIdList.size() <= 0) {
            return new ArrayList<Long>(16);
        }
        QFilter orgQFilter = new QFilter("roleid", "in", roleIdList);
        Map roleOrgMap = BusinessDataServiceHelper.loadFromCache((String)"upm_rolematerial", (QFilter[])orgQFilter.toArray());
        List<Long> orgIdList = roleOrgMap.values().stream().map(v -> v.getDynamicObject("materialmodid").getLong("id")).collect(Collectors.toList());
        return orgIdList;
    }

    public static List<Long> getRoleActionList(List<Long> roleIdList) {
        if (roleIdList == null || roleIdList.size() <= 0) {
            return new ArrayList<Long>(16);
        }
        QFilter orgQFilter = new QFilter("roleid", "in", roleIdList);
        Map roleActionMap = BusinessDataServiceHelper.loadFromCache((String)"upm_roleaction", (QFilter[])orgQFilter.toArray());
        List<Long> actionIdList = roleActionMap.values().stream().map(v -> v.getDynamicObject("actionid").getLong("id")).collect(Collectors.toList());
        return actionIdList;
    }

    public static List<Long> getRoleVehicleList(Long roleId) {
        if (roleId == null || roleId == 0L) {
            return new ArrayList<Long>(16);
        }
        ArrayList<Long> roleList = new ArrayList<Long>(16);
        roleList.add(roleId);
        return RoleDataIsolationHelper.getRoleVehicleList(roleList);
    }

    public static List<Long> getUserRoleVehicleList() {
        List<Long> userRoleList = RoleDataIsolationHelper.getUserRoleList();
        return RoleDataIsolationHelper.getRoleVehicleList(userRoleList);
    }

    public static boolean isExist(long orgId) {
        Object[] parameter = new Object[]{UserServiceHelper.getCurrentUserId(), orgId};
        String defineSql = "select u.froleid id from t_upm_userrole u join t_upm_roleorg r on  u.froleid = r.froleid where  u.fuserid=?  and  r.forgid=?";
        try (DataSet rows = DB.queryDataSet((String)"UserRoleAuthorityHelper", (DBRoute)DBRoute.of((String)"scm"), (String)defineSql, (Object[])parameter);){
            int num = rows.count("id", false);
            if (num >= 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

